/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.RefreshAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.datacollection.views.DataComparisonView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataComparisonView
extends ObjectView {
    private static final I18n i18n = LocalizationHelper.getI18n(DataComparisonView.class);
    private Chart chart;
    protected NXCSession session;
    private boolean updateInProgress = false;
    protected ArrayList<GraphItem> items = new ArrayList(8);
    private ViewRefreshController refreshController;
    private boolean autoRefreshEnabled = true;
    private boolean useLogScale = false;
    private int autoRefreshInterval = 30;
    private ChartType chartType = ChartType.BAR;
    private boolean transposed = false;
    private boolean showLegend = true;
    private int legendPosition = 8;
    private boolean translucent = false;
    private Image[] titleImages = new Image[4];
    private RefreshAction actionRefresh;
    private Action actionAutoRefresh;
    private Action actionShowBarChart;
    private Action actionShowPieChart;
    private Action actionShowTranslucent;
    private Action actionUseLogScale;
    private Action actionHorizontal;
    private Action actionVertical;
    private Action actionShowLegend;
    private Action actionLegendLeft;
    private Action actionLegendRight;
    private Action actionLegendTop;
    private Action actionLegendBottom;

    private static String buildId(ArrayList<GraphItem> items, ChartType type) {
        StringBuilder sb = new StringBuilder("DataComparisonView");
        sb.append('#');
        sb.append(type);
        for (GraphItem item : items) {
            sb.append('#');
            sb.append(item.getNodeId());
            sb.append('#');
            sb.append(item.getDciId());
        }
        return sb.toString();
    }

    public DataComparisonView(ArrayList<GraphItem> items, ChartType chartType) {
        super(i18n.tr("Last Values Chart"), ResourceManager.getImageDescriptor((String)(chartType == ChartType.PIE ? "icons/object-views/chart_pie.png" : "icons/chart_bar.png")), DataComparisonView.buildId(items, (ChartType)chartType), false);
        this.session = Registry.getSession();
        this.chartType = chartType;
        this.items = items;
    }

    protected void createContent(Composite parent) {
        ChartConfiguration chartConfiguration = new ChartConfiguration();
        chartConfiguration.setLegendPosition(this.legendPosition);
        chartConfiguration.setLegendVisible(this.showLegend);
        chartConfiguration.setTransposed(this.transposed);
        chartConfiguration.setTranslucent(this.translucent);
        this.chart = new Chart(parent, 0, this.chartType, chartConfiguration);
        for (GraphItem item : this.items) {
            this.chart.addParameter(item);
        }
        this.chart.rebuild();
        this.createActions();
        this.createPopupMenu();
        this.updateChart();
        this.refreshController = new ViewRefreshController((View)this, this.autoRefreshEnabled ? this.autoRefreshInterval : -1, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.chart);
        this.chart.setMenu(menu);
    }

    private void createActions() {
        this.actionRefresh = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAutoRefresh = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAutoRefresh.setChecked(this.autoRefreshEnabled);
        this.actionUseLogScale = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUseLogScale.setChecked(this.useLogScale);
        this.actionShowTranslucent = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowTranslucent.setChecked(this.translucent);
        this.actionShowLegend = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowLegend.setChecked(this.showLegend);
        this.actionLegendLeft = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLegendLeft.setChecked(this.legendPosition == 1);
        this.actionLegendRight = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLegendRight.setChecked(this.legendPosition == 2);
        this.actionLegendTop = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLegendTop.setChecked(this.legendPosition == 1);
        this.actionLegendBottom = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLegendBottom.setChecked(this.legendPosition == 1);
        this.actionShowBarChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowBarChart.setChecked(this.chartType == ChartType.BAR);
        this.actionShowBarChart.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/chart_bar.png"));
        this.actionShowPieChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowPieChart.setChecked(this.chartType == ChartType.PIE);
        this.actionShowPieChart.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/chart_pie.png"));
        this.actionHorizontal = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHorizontal.setChecked(this.transposed);
        this.actionHorizontal.setEnabled(this.chart.hasAxes());
        this.actionHorizontal.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/bar_horizontal.png"));
        this.actionVertical = new /* Unavailable Anonymous Inner Class!! */;
        this.actionVertical.setChecked(!this.transposed);
        this.actionVertical.setEnabled(this.chart.hasAxes());
        this.actionVertical.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/bar_vertical.png"));
    }

    private void fillContextMenu(IMenuManager manager) {
        MenuManager legend = new MenuManager(i18n.tr("&Legend"));
        legend.add((IAction)this.actionShowLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionVertical);
        manager.add((IAction)this.actionHorizontal);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowTranslucent);
        manager.add((IAction)this.actionUseLogScale);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IContributionItem)new Separator());
    }

    private void setChartType(ChartType newType) {
        this.chartType = newType;
        this.chart.getConfiguration().setLabelsVisible(this.chartType == ChartType.PIE);
        this.chart.setType(this.chartType);
        this.chart.rebuild();
        this.actionHorizontal.setEnabled(this.chart.hasAxes());
        this.actionVertical.setEnabled(this.chart.hasAxes());
    }

    private void updateChart() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        16 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void setChartData(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.chart.updateParameter(i, values[i], false);
        }
        this.chart.refresh();
    }

    public void dispose() {
        this.refreshController.dispose();
        for (Image i : this.titleImages) {
            if (i == null) continue;
            i.dispose();
        }
        super.dispose();
    }
}

