/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.Date;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.HistoricalDataSelectionDialog;
import org.netxms.nxmc.modules.datacollection.views.helpers.HistoricalDataComparator;
import org.netxms.nxmc.modules.datacollection.views.helpers.HistoricalDataFilter;
import org.netxms.nxmc.modules.datacollection.views.helpers.HistoricalDataLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class HistoricalDataView
extends ViewWithContext {
    private static final I18n i18n = LocalizationHelper.getI18n(HistoricalDataView.class);
    public static final int COLUMN_TIME = 0;
    public static final int COLUMN_DATA = 1;
    private NXCSession session = Registry.getSession();
    private long contextId;
    private long ownerId;
    private long dciId;
    private String fullName;
    private String nodeName;
    private String tableName;
    private String instance;
    private String column;
    private SortableTableViewer viewer;
    private Date timeFrom = null;
    private Date timeTo = null;
    private int recordLimit = 4096;
    private boolean updateInProgress = false;
    private Action actionSelectRange;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionDeleteDciEntry;

    private static String buildId(AbstractObject object, long dciId, String tableName, String instance, String column) {
        StringBuilder sb = new StringBuilder("HistoricalGraphView");
        if (object != null) {
            sb.append('#');
            sb.append(object.getObjectId());
        }
        sb.append('#');
        sb.append(dciId);
        if (tableName != null) {
            sb.append('#');
            sb.append(tableName);
        }
        if (instance != null) {
            sb.append('#');
            sb.append(instance);
        }
        if (column != null) {
            sb.append('#');
            sb.append(column);
        }
        return sb.toString();
    }

    public HistoricalDataView(AbstractObject contextObject, long ownerId, long dciId, String tableName, String instance, String column) {
        super(i18n.tr("Historical Data"), ResourceManager.getImageDescriptor((String)"icons/object-views/data_history.gif"), HistoricalDataView.buildId((AbstractObject)contextObject, (long)dciId, (String)tableName, (String)instance, (String)column), true);
        this.contextId = contextObject.getObjectId();
        this.ownerId = ownerId;
        this.dciId = dciId;
        this.tableName = tableName;
        this.instance = instance;
        this.column = column;
        this.nodeName = contextObject.getObjectName();
        String dciName = tableName == null ? Long.toString(dciId) : tableName;
        this.fullName = this.nodeName + ": [" + dciName + "]";
        this.setName(dciName);
    }

    public View cloneView() {
        HistoricalDataView view = (HistoricalDataView)super.cloneView();
        view.contextId = this.contextId;
        view.dciId = this.dciId;
        view.ownerId = this.ownerId;
        view.tableName = this.tableName;
        view.instance = this.instance;
        view.column = this.column;
        view.fullName = this.fullName;
        view.nodeName = this.nodeName;
        return view;
    }

    public HistoricalDataView() {
        super(i18n.tr("Historical Data"), ResourceManager.getImageDescriptor((String)"icons/object-views/data_history.gif"), UUID.randomUUID().toString(), true);
    }

    public String getFullName() {
        return this.fullName;
    }

    protected void createContent(Composite parent) {
        String[] stringArray;
        if (this.tableName != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = i18n.tr("Timestamp");
            stringArray = stringArray2;
            stringArray2[1] = i18n.tr("Value");
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = i18n.tr("Timestamp");
            stringArray3[1] = i18n.tr("Value");
            stringArray = stringArray3;
            stringArray3[2] = i18n.tr("Raw value");
        }
        String[] names = stringArray;
        int[] widths = new int[]{150, 400, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new HistoricalDataLabelProvider());
        this.viewer.setComparator((ViewerComparator)new HistoricalDataComparator());
        HistoricalDataFilter filter = new HistoricalDataFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((StructuredViewer)this.viewer, (AbstractViewerFilter)filter);
        this.createActions();
        this.createPopupMenu();
        this.refresh();
    }

    private void createActions() {
        this.actionSelectRange = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeleteDciEntry = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionDeleteDciEntry);
        manager.add((IAction)this.actionSelectRange);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    public void refresh() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void selectRange() {
        HistoricalDataSelectionDialog dlg = new HistoricalDataSelectionDialog(this.getWindow().getShell(), this.recordLimit, this.timeFrom, this.timeTo);
        if (dlg.open() == 0) {
            this.recordLimit = dlg.getMaxRecords();
            this.timeFrom = dlg.getTimeFrom();
            this.timeTo = dlg.getTimeTo();
            this.refresh();
        }
    }

    private void deleteValue() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractObject && ((AbstractObject)context).getObjectId() == this.contextId;
    }

    protected void contextChanged(Object oldContext, Object newContext) {
        if (newContext == null || !(newContext instanceof AbstractObject) || ((AbstractObject)newContext).getObjectId() != this.contextId) {
            return;
        }
        this.refresh();
    }

    public boolean isCloseable() {
        return true;
    }
}

