/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.DciList;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.DciListComparator;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.DciListFilter;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.DciListLabelProvider;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class DciList
extends Composite {
    private static final I18n i18n = LocalizationHelper.getI18n(DciList.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_PARAMETER = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private boolean filterEnabled = true;
    private DciListFilter filter;
    private FilterText filterText;
    private View view;
    private AbstractObject node;
    private NXCSession session = Registry.getSession();
    private SortableTableViewer viewer;
    private int dcObjectType;
    private boolean allowNoValueObjects = false;

    public DciList(View view, Composite parent, int style, AbstractNode _node, String configPrefix, int dcObjectType, int selectionType, boolean allowNoValueObjects) {
        super(parent, style);
        this.view = view;
        this.node = _node;
        this.dcObjectType = dcObjectType;
        this.allowNoValueObjects = allowNoValueObjects;
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.filterText = new FilterText((Composite)this, 0, null, false);
        this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filterText.setCloseAction((Action)new /* Unavailable Anonymous Inner Class!! */);
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Parameter"), i18n.tr("Description")};
        int[] widths = new int[]{70, 150, 250};
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 2, 1024, selectionType | 0x10000);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DciListLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new DciListComparator());
        this.filter = new DciListFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)configPrefix);
        this.addListener(11, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.getDataFromServer();
    }

    private void getDataFromServer() {
        if (this.node == null) {
            this.viewer.setInput((Object)new DciValue[0]);
            return;
        }
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void setNode(AbstractObject node) {
        this.node = node;
        this.getDataFromServer();
    }

    public void refresh() {
        this.getDataFromServer();
    }

    public List<DciValue> getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return new ArrayList<DciValue>(selection.toList());
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        this.getDataFromServer();
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.viewer.addDoubleClickListener(listener);
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    public String getFilter() {
        return this.filterText.getText();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

