/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.TableCondition;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.TableColumnEnumerator;
import org.netxms.nxmc.modules.datacollection.widgets.TableConditionsEditor;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class TableConditionsEditor
extends Composite {
    private static I18n i18n = LocalizationHelper.getI18n(TableConditionsEditor.class);
    private ScrolledComposite scroller;
    private ImageHyperlink addColumnLink;
    private List<GroupEditor> groups = new ArrayList();
    private TableColumnEnumerator columnEnumerator = null;
    private List<String> columnList;

    public TableConditionsEditor(Composite parent, int style, TableColumnEnumerator columnEnumerator) {
        super(parent, style);
        this.columnEnumerator = columnEnumerator;
        this.setLayout((Layout)new FillLayout());
        this.scroller = new ScrolledComposite((Composite)this, 0);
        this.scroller.setLayout((Layout)new GridLayout());
        this.addColumnLink = new ImageHyperlink((Composite)this.scroller, 0);
        this.addColumnLink.setText(i18n.tr("Add..."));
        this.addColumnLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        this.addColumnLink.setToolTipText(i18n.tr("Add new condition group"));
        this.addColumnLink.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setConditions(List<List<TableCondition>> conditions) {
        for (List<TableCondition> g : conditions) {
            this.addGroup((Control)this.addColumnLink, g);
        }
        this.scroller.layout(true);
    }

    public List<List<TableCondition>> getConditions() {
        ArrayList<List<TableCondition>> result = new ArrayList<List<TableCondition>>(this.groups.size());
        for (GroupEditor ge : this.groups) {
            result.add(ge.getConditions());
        }
        return result;
    }

    private void addGroup(Control lastControl, List<TableCondition> initialData) {
        GroupEditor editor = new GroupEditor(this, (Composite)this.scroller);
        editor.moveAbove(lastControl);
        editor.setLayoutData((Object)new GridData(4, 128, true, false));
        this.groups.add(editor);
        if (initialData != null) {
            for (TableCondition c : initialData) {
                editor.addCondition(c);
            }
        } else {
            this.scroller.layout(true);
        }
    }

    private void deleteGroup(GroupEditor editor) {
        this.groups.remove(editor);
        editor.dispose();
        this.scroller.layout(true);
    }
}

