/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class ThresholdLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = Registry.getSession();
    private Image thresholdIcon = ResourceManager.getImageDescriptor((String)"icons/threshold.png").createImage();

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.thresholdIcon;
            }
            case 1: {
                EventTemplate event = this.session.findEventTemplateByCode((long)((Threshold)element).getFireEvent());
                return StatusDisplayInfo.getStatusImage((Severity)(event != null ? event.getSeverity() : Severity.UNKNOWN));
            }
            case 2: {
                EventTemplate rearmEvent = this.session.findEventTemplateByCode((long)((Threshold)element).getRearmEvent());
                return StatusDisplayInfo.getStatusImage((Severity)(rearmEvent != null ? rearmEvent.getSeverity() : Severity.UNKNOWN));
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ((Threshold)element).getTextualRepresentation();
            }
            case 1: {
                return this.session.getEventName((long)((Threshold)element).getFireEvent());
            }
            case 2: {
                return this.session.getEventName((long)((Threshold)element).getRearmEvent());
            }
        }
        return null;
    }

    public void dispose() {
        this.thresholdIcon.dispose();
        super.dispose();
    }
}

