/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.services.ObjectDoubleClickHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectDoubleClickHandlerRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ObjectDoubleClickHandlerRegistry.class);
    private View view;
    private List<ObjectDoubleClickHandler> doubleClickHandlers = new ArrayList(0);
    private boolean defaultHandlerEnabled = true;

    public ObjectDoubleClickHandlerRegistry(View view) {
        this.view = view;
        this.registerDoubleClickHandlers();
    }

    public boolean handleDoubleClick(AbstractObject object) {
        AbstractObject drillDownObject;
        for (ObjectDoubleClickHandler h : this.doubleClickHandlers) {
            if (h.enabledFor() != null && !h.enabledFor().isInstance(object) || !h.onDoubleClick(object, this.view)) continue;
            return true;
        }
        if (!this.defaultHandlerEnabled || object.getDrillDownObjectId() == 0L || (drillDownObject = Registry.getSession().findObjectById(object.getDrillDownObjectId())) instanceof NetworkMap || drillDownObject instanceof Dashboard) {
            // empty if block
        }
        return false;
    }

    public boolean isDefaultHandlerEnabled() {
        return this.defaultHandlerEnabled;
    }

    public void setDefaultHandlerEnabled(boolean defaultHandlerEnabled) {
        this.defaultHandlerEnabled = defaultHandlerEnabled;
    }

    private void registerDoubleClickHandlers() {
        ServiceLoader<ObjectDoubleClickHandler> loader = ServiceLoader.load(ObjectDoubleClickHandler.class, this.getClass().getClassLoader());
        for (ObjectDoubleClickHandler h : loader) {
            logger.debug("Adding object double click handler " + h.getDescription());
            this.doubleClickHandlers.add(h);
        }
        this.doubleClickHandlers.sort(new /* Unavailable Anonymous Inner Class!! */);
    }
}

