/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.propertypages.LinkGeneral;
import org.netxms.nxmc.modules.networkmaps.views.helpers.LinkEditor;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptSelector;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class LinkGeneral
extends PreferencePage {
    private static I18n i18n = LocalizationHelper.getI18n(LinkGeneral.class);
    private LinkEditor object;
    private LabeledText name;
    private LabeledText connector1;
    private LabeledText connector2;
    private Button radioColorDefault;
    private Button radioColorObject;
    private Button radioColorScript;
    private Button radioColorCustom;
    private ScriptSelector script;
    private ColorSelector color;
    private List list;
    private Button add;
    private Button remove;
    private Combo routingAlgorithm;
    private Button checkUseThresholds;

    public LinkGeneral(LinkEditor object) {
        super(i18n.tr("General"));
        this.object = object;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(i18n.tr("Name"));
        this.name.setText(this.object.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.connector1 = new LabeledText(dialogArea, 0);
        this.connector1.setLabel(i18n.tr("Name for connector 1"));
        this.connector1.setText(this.object.getConnectorName1());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.connector1.setLayoutData((Object)gd);
        this.connector2 = new LabeledText(dialogArea, 0);
        this.connector2.setLabel(i18n.tr("Name for connector 2"));
        this.connector2.setText(this.object.getConnectorName2());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.connector2.setLayoutData((Object)gd);
        Group colorGroup = new Group(dialogArea, 0);
        colorGroup.setText(i18n.tr("Color"));
        layout = new GridLayout();
        colorGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        colorGroup.setLayoutData((Object)gd);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioColorDefault = new Button((Composite)colorGroup, 16);
        this.radioColorDefault.setText(i18n.tr("&Default color"));
        this.radioColorDefault.setSelection(this.object.getColorSource() == 0);
        this.radioColorDefault.addSelectionListener((SelectionListener)listener);
        this.radioColorObject = new Button((Composite)colorGroup, 16);
        this.radioColorObject.setText(i18n.tr("Based on object &status"));
        this.radioColorObject.setSelection(this.object.getColorSource() == 1);
        this.radioColorObject.addSelectionListener((SelectionListener)listener);
        Composite nodeSelectionGroup = new Composite((Composite)colorGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        nodeSelectionGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        nodeSelectionGroup.setLayoutData((Object)gd);
        this.list = new List(nodeSelectionGroup, 2820);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalSpan = 2;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.list.setLayoutData((Object)gd);
        if (this.object.getStatusObjects() != null) {
            NXCSession session = Registry.getSession();
            for (Long id : this.object.getStatusObjects()) {
                this.list.add(session.getObjectName(id.longValue()));
            }
        }
        this.list.setEnabled(this.radioColorObject.getSelection());
        this.add = new Button(nodeSelectionGroup, 8);
        this.add.setText(i18n.tr("&Add..."));
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 128;
        this.add.setLayoutData((Object)gd);
        this.add.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add.setEnabled(this.radioColorObject.getSelection());
        this.remove = new Button(nodeSelectionGroup, 8);
        this.remove.setText(i18n.tr("&Delete"));
        gd.widthHint = 90;
        gd.verticalAlignment = 128;
        this.remove.setLayoutData((Object)gd);
        this.remove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.remove.setEnabled(this.radioColorObject.getSelection());
        this.checkUseThresholds = new Button(nodeSelectionGroup, 32);
        this.checkUseThresholds.setText("Include active thresholds into calculation");
        this.checkUseThresholds.setEnabled(this.radioColorObject.getSelection());
        this.checkUseThresholds.setSelection(this.object.isUseActiveThresholds());
        gd = new GridData();
        gd.horizontalIndent = 17;
        this.checkUseThresholds.setLayoutData((Object)gd);
        this.radioColorScript = new Button((Composite)colorGroup, 16);
        this.radioColorScript.setText("Script");
        this.radioColorScript.setSelection(this.object.getColorSource() == 3);
        this.radioColorScript.addSelectionListener((SelectionListener)listener);
        this.script = new ScriptSelector((Composite)colorGroup, 0, false, false);
        this.script.setScriptName(this.object.getColorProvider());
        if (this.radioColorScript.getSelection()) {
            this.script.setScriptName(this.object.getColorProvider());
        } else {
            this.script.setEnabled(false);
        }
        gd = new GridData();
        gd.horizontalIndent = 20;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.script.setLayoutData((Object)gd);
        this.radioColorCustom = new Button((Composite)colorGroup, 16);
        this.radioColorCustom.setText(i18n.tr("&Custom color"));
        this.radioColorCustom.setSelection(this.object.getColorSource() == 2);
        this.radioColorCustom.addSelectionListener((SelectionListener)listener);
        this.color = new ColorSelector((Composite)colorGroup);
        if (this.radioColorCustom.getSelection()) {
            this.color.setColorValue(ColorConverter.rgbFromInt((int)this.object.getColor()));
        } else {
            this.color.setEnabled(false);
        }
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.color.getButton().setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.routingAlgorithm = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Routing algorithm"), (Object)gd);
        this.routingAlgorithm.add(i18n.tr("Map default"));
        this.routingAlgorithm.add(i18n.tr("Direct"));
        this.routingAlgorithm.add(i18n.tr("Manhattan"));
        this.routingAlgorithm.add(i18n.tr("Bend points"));
        this.routingAlgorithm.select(this.object.getRoutingAlgorithm());
        return dialogArea;
    }

    private void addObject() {
        AbstractObject[] objects;
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0 && (objects = dlg.getSelectedObjects(AbstractObject.class)).length > 0) {
            for (AbstractObject obj : objects) {
                this.object.addStatusObject(Long.valueOf(obj.getObjectId()));
                this.list.add((String)(obj != null ? obj.getObjectName() : "<" + Long.toString(obj.getObjectId()) + ">"));
            }
        }
    }

    private void removeObject() {
        int index = this.list.getSelectionIndex();
        this.list.remove(index);
        this.object.removeStatusObjectByIndex(index);
    }

    private boolean applyChanges(boolean isApply) {
        this.object.setName(this.name.getText());
        this.object.setConnectorName1(this.connector1.getText());
        this.object.setConnectorName2(this.connector2.getText());
        if (this.radioColorCustom.getSelection()) {
            this.object.setColor(ColorConverter.rgbToInt((RGB)this.color.getColorValue()));
            this.object.setColorSource(2);
        } else if (this.radioColorObject.getSelection()) {
            this.object.setColorSource(1);
        } else if (this.radioColorScript.getSelection()) {
            this.object.setColorSource(3);
            this.object.setColorProvider(this.script.getScriptName());
        } else {
            this.object.setColorSource(0);
        }
        this.object.setUseActiveThresholds(this.checkUseThresholds.getSelection());
        this.object.setRoutingAlgorithm(this.routingAlgorithm.getSelectionIndex());
        this.object.update();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

