/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.widgets.helpers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.nxmc.tools.ColorCache;
import org.netxms.nxmc.tools.ColorConverter;

public class ConnectorLabel
extends Label {
    private static final Color DEFAULT_FOREGROUND_COLOR = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color DEFAULT_BACKGROUND_COLOR = new Color((Device)Display.getCurrent(), 166, 205, 139);
    private Color backgroundColor = null;
    private ColorCache cCache = new ColorCache();

    public ConnectorLabel(String s) {
        super(s);
        this.initLabel();
    }

    public ConnectorLabel(String s, Color backgroundColor) {
        super(s);
        this.backgroundColor = backgroundColor;
        this.initLabel();
    }

    public ConnectorLabel(String s, Image i) {
        super(s, i);
        this.initLabel();
    }

    private void initLabel() {
        this.setForegroundColor(this.backgroundColor == null ? DEFAULT_FOREGROUND_COLOR : ColorConverter.selectTextColorByBackgroundColor((Color)this.backgroundColor, (ColorCache)this.cCache));
        this.setBackgroundColor(this.backgroundColor == null ? DEFAULT_BACKGROUND_COLOR : this.backgroundColor);
    }

    protected void paintFigure(Graphics gc) {
        Rectangle bounds = this.getBounds();
        gc.setBackgroundColor(this.backgroundColor == null ? DEFAULT_BACKGROUND_COLOR : this.backgroundColor);
        gc.setAntialias(1);
        gc.fillRoundRectangle(bounds, 8, 8);
        gc.translate(bounds.x, bounds.y);
        Point pos = this.getTextLocation();
        gc.drawText(this.getSubStringText(), pos.x + 3, pos.y);
        gc.translate(-bounds.x, -bounds.y);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension d = this.calculateLabelSize(this.getTextSize());
        Insets insets = this.getInsets();
        d.expand(insets.getWidth(), insets.getHeight());
        if (this.getLayoutManager() != null) {
            d.union(this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint));
        }
        d.height += 4;
        d.width += 6;
        return d;
    }
}

