/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.xnap.commons.i18n.I18n;

public class ScriptEditDialog
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(ScriptEditDialog.class);
    private String script;
    private ScriptEditor editor;
    private String hints;

    public ScriptEditDialog(Shell parentShell, String script, String hints) {
        super(parentShell);
        this.script = script;
        this.hints = hints;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Edit Script"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.editor = new ScriptEditor(area, 2048, 768, true, this.hints);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 600;
        gd.heightHint = 400;
        this.editor.setLayoutData((Object)gd);
        this.editor.setText(this.script);
        return area;
    }

    protected void okPressed() {
        this.script = this.editor.getText();
        super.okPressed();
    }

    public String getScript() {
        return this.script;
    }
}

