/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SelectScriptDialog
extends Dialog {
    private static I18n i18n = LocalizationHelper.getI18n(SelectScriptDialog.class);
    private TableViewer viewer;
    private List<Script> selection = new ArrayList(0);
    private boolean multiSelection = false;

    public SelectScriptDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(i18n.tr("Select script"));
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText(i18n.tr("Available scripts"));
        this.viewer = new TableViewer(dialogArea, 0x10800 | (this.multiSelection ? 2 : 0));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (s.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("You must select script from list and then press OK."));
            return;
        }
        for (Object o : s.toList()) {
            this.selection.add((Script)o);
        }
        super.okPressed();
    }

    public Script getScript() {
        return this.selection.size() > 0 ? (Script)this.selection.get(0) : null;
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean multiSelection) {
        this.multiSelection = multiSelection;
    }

    public List<Script> getSelection() {
        return this.selection;
    }
}

