/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectPollType;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServicePrototype;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.interfaces.PollingTarget;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.ObjectToolExecutor;
import org.netxms.nxmc.modules.objects.ObjectToolsCache;
import org.netxms.nxmc.modules.objects.ObjectWrapper;
import org.netxms.nxmc.tools.ImageCache;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ObjectMenuFactory {
    private static I18n i18n = LocalizationHelper.getI18n(ObjectMenuFactory.class);
    private static final String[] POLL_NAME = new String[]{"", i18n.tr("Status"), i18n.tr("Configuration (Full)"), i18n.tr("Interface"), i18n.tr("Topology"), i18n.tr("Configuration"), i18n.tr("Instance discovery"), i18n.tr("Routing table"), i18n.tr("Network discovery"), i18n.tr("Automatic binding")};

    public static Menu createPollMenu(IStructuredSelection selection, Menu parentMenu, Control parentControl, ViewPlacement viewPlacement) {
        Menu menu;
        if (selection.size() > 1) {
            return null;
        }
        AbstractObject object = (AbstractObject)selection.getFirstElement();
        if (!(object instanceof PollingTarget)) {
            return null;
        }
        Menu menu2 = menu = parentMenu != null ? new Menu(parentMenu) : new Menu(parentControl);
        if (object instanceof AbstractNode) {
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.STATUS, (ViewPlacement)viewPlacement);
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.CONFIGURATION_NORMAL, (ViewPlacement)viewPlacement);
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.CONFIGURATION_FULL, (ViewPlacement)viewPlacement);
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.INSTANCE_DISCOVERY, (ViewPlacement)viewPlacement);
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.INTERFACES, (ViewPlacement)viewPlacement);
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.TOPOLOGY, (ViewPlacement)viewPlacement);
        } else if (object instanceof BusinessServicePrototype) {
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.INSTANCE_DISCOVERY, (ViewPlacement)viewPlacement);
        } else if (object instanceof BusinessService || object instanceof Cluster) {
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.STATUS, (ViewPlacement)viewPlacement);
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.CONFIGURATION_NORMAL, (ViewPlacement)viewPlacement);
        } else if (object instanceof Container || object instanceof Template) {
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.AUTOBIND, (ViewPlacement)viewPlacement);
        } else if (object instanceof Sensor) {
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.STATUS, (ViewPlacement)viewPlacement);
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.CONFIGURATION_NORMAL, (ViewPlacement)viewPlacement);
            ObjectMenuFactory.addPollMenuItem((Menu)menu, (AbstractObject)object, (ObjectPollType)ObjectPollType.INSTANCE_DISCOVERY, (ViewPlacement)viewPlacement);
        }
        if (menu.getItemCount() == 0) {
            menu.dispose();
            return null;
        }
        return menu;
    }

    public static void addPollMenuItem(Menu menu, AbstractObject object, ObjectPollType type, ViewPlacement viewPlacement) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(POLL_NAME[type.getValue()]);
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Menu createToolsMenu(IStructuredSelection selection, Menu parentMenu, Control parentControl, ViewPlacement viewPlacement) {
        Set nodes = ObjectMenuFactory.buildNodeSet((IStructuredSelection)selection);
        Menu toolsMenu = parentMenu != null ? new Menu(parentMenu) : new Menu(parentControl);
        ImageCache imageCache = new ImageCache();
        toolsMenu.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        ObjectTool[] tools = ObjectToolsCache.getInstance().getTools();
        Arrays.sort(tools, new /* Unavailable Anonymous Inner Class!! */);
        HashMap<CallSite, Menu> menus = new HashMap<CallSite, Menu>();
        for (int i = 0; i < tools.length; ++i) {
            boolean enabled;
            boolean bl = enabled = (tools[i].getFlags() & 4) == 0;
            if (!enabled || !ObjectToolExecutor.isToolAllowed((ObjectTool)tools[i], (Set)nodes) || !ObjectToolExecutor.isToolApplicable((ObjectTool)tools[i], (Set)nodes)) continue;
            String[] path = tools[i].getName().split("\\-\\>");
            Menu rootMenu = toolsMenu;
            for (int j = 0; j < path.length - 1; ++j) {
                String key = rootMenu.hashCode() + "@" + path[j].replace("&", "");
                Menu currMenu = (Menu)menus.get(key);
                if (currMenu == null) {
                    currMenu = new Menu(rootMenu);
                    MenuItem item = new MenuItem(rootMenu, 64);
                    item.setText(path[j]);
                    item.setMenu(currMenu);
                    menus.put((CallSite)((Object)key), currMenu);
                }
                rootMenu = currMenu;
            }
            MenuItem item = new MenuItem(rootMenu, 8);
            item.setText(path[path.length - 1]);
            ImageDescriptor icon = ObjectToolsCache.getInstance().findIcon(tools[i].getId());
            if (icon != null) {
                item.setImage(imageCache.create(icon));
            }
            item.setData((Object)tools[i]);
            item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (toolsMenu.getItemCount() == 0) {
            toolsMenu.dispose();
            return null;
        }
        return toolsMenu;
    }

    private static Set<ObjectContext> buildNodeSet(IStructuredSelection selection) {
        HashSet<ObjectContext> nodes = new HashSet<ObjectContext>();
        NXCSession session = Registry.getSession();
        for (Object o : selection.toList()) {
            AbstractObject n;
            if (o instanceof AbstractNode) {
                nodes.add(new ObjectContext((AbstractNode)o, null));
                continue;
            }
            if (o instanceof Container || o instanceof ServiceRoot || o instanceof Subnet || o instanceof Cluster) {
                for (AbstractObject n2 : ((AbstractObject)o).getAllChildren(2)) {
                    nodes.add(new ObjectContext((AbstractNode)n2, null));
                }
                continue;
            }
            if (o instanceof Alarm) {
                n = (AbstractNode)session.findObjectById(((Alarm)o).getSourceObjectId(), AbstractNode.class);
                if (n == null) continue;
                nodes.add(new ObjectContext((AbstractNode)n, (Alarm)o));
                continue;
            }
            if (!(o instanceof ObjectWrapper) || (n = ((ObjectWrapper)o).getObject()) == null || !(n instanceof AbstractNode)) continue;
            nodes.add(new ObjectContext((AbstractNode)n, null));
        }
        return nodes;
    }
}

