/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class ClusterNetworkEditDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(ClusterNetworkEditDialog.class);
    private Text textAddress;
    private Text textMask;
    private InetAddress address;
    private InetAddress mask;

    public ClusterNetworkEditDialog(Shell parentShell, InetAddress address, InetAddress mask) {
        super(parentShell);
        this.address = address;
        this.mask = mask;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.address == null ? this.i18n.tr("Add Network") : this.i18n.tr("Modify Network"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Address"));
        this.textAddress = new Text(dialogArea, 2052);
        this.textAddress.setTextLimit(15);
        if (this.address != null) {
            this.textAddress.setText(this.address.getHostAddress());
        }
        label = new Label(dialogArea, 0);
        label.setText("");
        label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("Mask"));
        this.textMask = new Text(dialogArea, 2052);
        this.textMask.setTextLimit(15);
        this.textMask.getShell().setMinimumSize(300, 0);
        if (this.mask != null) {
            this.textMask.setText(this.mask.getHostAddress());
        }
        return dialogArea;
    }

    protected void okPressed() {
        try {
            this.address = InetAddress.getByName(this.textAddress.getText());
            this.mask = InetAddress.getByName(this.textMask.getText());
        }
        catch (UnknownHostException e) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid IP address and network mask"));
            return;
        }
        super.okPressed();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getMask() {
        return this.mask;
    }
}

