/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateObjectDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(CreateObjectDialog.class);
    private String objectClassName;
    private String objectName;
    private Text textName;

    public CreateObjectDialog(Shell parentShell, String objectClassName) {
        super(parentShell);
        this.objectClassName = objectClassName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format(this.i18n.tr("Create %s"), this.objectClassName));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)this.i18n.tr("Object name"), (String)"", (Object)"WidgetHelper::default_layout_data");
        this.textName.getShell().setMinimumSize(300, 0);
        this.textName.setTextLimit(63);
        this.textName.setFocus();
        return dialogArea;
    }

    protected void okPressed() {
        this.objectName = this.textName.getText().trim();
        if (this.objectName.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Object name cannot be empty"));
            return;
        }
        super.okPressed();
    }

    public String getObjectName() {
        return this.objectName;
    }
}

