/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.HashSet;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.configs.ChassisPlacement;
import org.netxms.client.objects.interfaces.HardwareEntity;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.widgets.ImageSelector;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class PhysicalContainerPlacement
extends ObjectPropertyPage {
    private static final Logger logger = LoggerFactory.getLogger(PhysicalContainerPlacement.class);
    private static I18n i18n = LocalizationHelper.getI18n(PhysicalContainerPlacement.class);
    private static final String[] ORIENTATION = new String[]{"Fill", "Front", "Rear"};
    private static final String[] CHASSIS_ORIENTATION = new String[]{"Front", "Rear"};
    private static final String[] VERTICAL_UNITS = new String[]{"RU", "mm"};
    private static final String[] HORIZONTAL_UNITS = new String[]{"HP", "mm"};
    private Composite dialogArea;
    private HardwareEntity hardwareEntity;
    private Composite rackElements;
    private ObjectSelector objectSelector;
    private ImageSelector rackImageFrontSelector;
    private ImageSelector rackImageRearSelector;
    private LabeledSpinner rackHeight;
    private LabeledSpinner rackPosition;
    private Combo rackOrientation;
    private Composite chassisElements;
    private ImageSelector chassisImageSelector;
    private LabeledSpinner chassisHeight;
    private Combo chassisHeightUnits;
    private LabeledSpinner chassisWidth;
    private Combo chassisWidthUnits;
    private LabeledSpinner chassisVerticalPosition;
    private Combo chassisVerticalPositionUnits;
    private LabeledSpinner chassisHorizontalPosition;
    private Combo chassisHorizontalPositionUnits;
    private Combo chassisOrientation;

    public PhysicalContainerPlacement(AbstractObject object) {
        super(i18n.tr("Rack or Chassis"), object);
    }

    public String getId() {
        return "physicalCOntainerPlacement";
    }

    public boolean isVisible() {
        return this.object instanceof HardwareEntity;
    }

    protected Control createContents(Composite parent) {
        this.dialogArea = new Composite(parent, 0);
        this.hardwareEntity = (HardwareEntity)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(this.dialogArea, 0, true);
        this.objectSelector.setLabel("Rack or chassis");
        this.objectSelector.setObjectId(this.hardwareEntity.getPhysicalContainerId());
        HashSet<Class> filter = new HashSet<Class>();
        filter.add(Rack.class);
        if (!(this.object instanceof Chassis)) {
            filter.add(Chassis.class);
            this.objectSelector.setClassFilter(ObjectSelectionDialog.createRackOrChassisSelectionFilter());
        } else {
            this.objectSelector.setClassFilter(ObjectSelectionDialog.createRackSelectionFilter());
        }
        this.objectSelector.setObjectClass(filter);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.objectSelector.setLayoutData((Object)gd);
        this.objectSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.updateFieldControls();
        return this.dialogArea;
    }

    private void updateFieldControls() {
        AbstractObject selectedObject = this.objectSelector.getObject();
        if (selectedObject != null) {
            if (selectedObject instanceof Rack) {
                this.createRackFieldControls();
            } else {
                this.createChassisFieldControls();
            }
        } else if (this.object instanceof Chassis) {
            this.createRackFieldControls();
        } else if (this.rackElements != null) {
            this.rackElements.dispose();
            this.rackElements = null;
        } else if (this.chassisElements != null) {
            this.chassisElements.dispose();
            this.chassisElements = null;
        }
        this.dialogArea.getParent().layout(true, true);
    }

    private void createChassisFieldControls() {
        ChassisPlacement placement;
        if (this.chassisElements != null) {
            return;
        }
        if (this.rackElements != null) {
            this.rackElements.dispose();
            this.rackElements = null;
        }
        if ((placement = this.hardwareEntity.getChassisPlacement()) == null) {
            placement = new ChassisPlacement();
        }
        this.chassisElements = new Composite(this.dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        this.chassisElements.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.chassisElements.setLayoutData((Object)gd);
        this.chassisImageSelector = new ImageSelector(this.chassisElements, 0);
        this.chassisImageSelector.setLabel("Chassis image");
        this.chassisImageSelector.setImageGuid(placement.getImage(), true);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.chassisImageSelector.setLayoutData((Object)gd);
        Group sizeGroup = new Group(this.chassisElements, 0);
        sizeGroup.setText("Size");
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        sizeGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        sizeGroup.setLayoutData((Object)gd);
        this.chassisHeight = new LabeledSpinner((Composite)sizeGroup, 0);
        this.chassisHeight.setRange(0, 10000);
        this.chassisHeight.setLabel("Height");
        this.chassisHeight.setText(Integer.toString(placement.getHeight()));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        this.chassisHeight.setLayoutData((Object)gd);
        this.chassisHeightUnits = new Combo((Composite)sizeGroup, 8);
        this.chassisHeightUnits.setItems(VERTICAL_UNITS);
        this.chassisHeightUnits.select(placement.getHeightUnits());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        this.chassisHeightUnits.setLayoutData((Object)gd);
        this.chassisWidth = new LabeledSpinner((Composite)sizeGroup, 0);
        this.chassisWidth.setRange(0, 10000);
        this.chassisWidth.setLabel("Width");
        this.chassisWidth.setText(Integer.toString(placement.getWidth()));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        this.chassisWidth.setLayoutData((Object)gd);
        this.chassisWidthUnits = new Combo((Composite)sizeGroup, 8);
        this.chassisWidthUnits.setItems(HORIZONTAL_UNITS);
        this.chassisWidthUnits.select(placement.getWidthUnits());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        this.chassisWidthUnits.setLayoutData((Object)gd);
        Group positionGroup = new Group(this.chassisElements, 0);
        positionGroup.setText("Position");
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        positionGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        positionGroup.setLayoutData((Object)gd);
        this.chassisVerticalPosition = new LabeledSpinner((Composite)positionGroup, 0);
        this.chassisVerticalPosition.setRange(0, 10000);
        this.chassisVerticalPosition.setLabel("Vertical");
        this.chassisVerticalPosition.setText(Integer.toString(placement.getPositionHeight()));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        this.chassisVerticalPosition.setLayoutData((Object)gd);
        this.chassisVerticalPositionUnits = new Combo((Composite)positionGroup, 8);
        this.chassisVerticalPositionUnits.setItems(VERTICAL_UNITS);
        this.chassisVerticalPositionUnits.select(placement.getPositionHeightUnits());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        this.chassisVerticalPositionUnits.setLayoutData((Object)gd);
        this.chassisHorizontalPosition = new LabeledSpinner((Composite)positionGroup, 0);
        this.chassisHorizontalPosition.setRange(0, 10000);
        this.chassisHorizontalPosition.setLabel("Horizontal");
        this.chassisHorizontalPosition.setText(Integer.toString(placement.getPositionWidth()));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        this.chassisHorizontalPosition.setLayoutData((Object)gd);
        this.chassisHorizontalPositionUnits = new Combo((Composite)positionGroup, 8);
        this.chassisHorizontalPositionUnits.setItems(HORIZONTAL_UNITS);
        this.chassisHorizontalPositionUnits.select(placement.getPositionWidthUnits());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        this.chassisHorizontalPositionUnits.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.chassisOrientation = WidgetHelper.createLabeledCombo((Composite)this.chassisElements, (int)8, (String)"Orientation", (Object)gd);
        this.chassisOrientation.setItems(CHASSIS_ORIENTATION);
        this.chassisOrientation.select(placement.getOritentaiton() - 1);
    }

    private void createRackFieldControls() {
        if (this.rackElements != null) {
            return;
        }
        if (this.chassisElements != null) {
            this.chassisElements.dispose();
            this.chassisElements = null;
        }
        this.rackElements = new Composite(this.dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        this.rackElements.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.rackElements.setLayoutData((Object)gd);
        this.rackImageFrontSelector = new ImageSelector(this.rackElements, 0);
        this.rackImageFrontSelector.setLabel("Rack front image");
        this.rackImageFrontSelector.setImageGuid(this.hardwareEntity.getFrontRackImage(), true);
        this.rackImageFrontSelector.setEnabled(this.hardwareEntity.getRackOrientation() == RackOrientation.FRONT || this.hardwareEntity.getRackOrientation() == RackOrientation.FILL);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        this.rackImageFrontSelector.setLayoutData((Object)gd);
        this.rackImageRearSelector = new ImageSelector(this.rackElements, 0);
        this.rackImageRearSelector.setLabel("Rack rear image");
        this.rackImageRearSelector.setImageGuid(this.hardwareEntity.getRearRackImage(), true);
        this.rackImageRearSelector.setEnabled(this.hardwareEntity.getRackOrientation() == RackOrientation.REAR || this.hardwareEntity.getRackOrientation() == RackOrientation.FILL);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        this.rackImageRearSelector.setLayoutData((Object)gd);
        this.rackPosition = new LabeledSpinner(this.rackElements, 0);
        this.rackPosition.setLabel(i18n.tr("Position"));
        this.rackPosition.setRange(1, 50);
        this.rackPosition.setSelection((int)this.hardwareEntity.getRackPosition());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.rackPosition.setLayoutData((Object)gd);
        this.rackHeight = new LabeledSpinner(this.rackElements, 0);
        this.rackHeight.setLabel(i18n.tr("Height"));
        this.rackHeight.setRange(1, 50);
        this.rackHeight.setSelection((int)this.hardwareEntity.getRackHeight());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.rackHeight.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.rackOrientation = WidgetHelper.createLabeledCombo((Composite)this.rackElements, (int)8, (String)"Orientation", (Object)gd);
        this.rackOrientation.setItems(ORIENTATION);
        this.rackOrientation.select(this.hardwareEntity.getRackOrientation().getValue());
        this.rackOrientation.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        AbstractObject obj = this.objectSelector.getObject();
        if (obj != null) {
            md.setPhysicalContainer(this.objectSelector.getObjectId());
            if (obj instanceof Rack) {
                md.setRackPlacement(this.rackImageFrontSelector.getImageGuid(), this.rackImageRearSelector.getImageGuid(), (short)this.rackPosition.getSelection(), (short)this.rackHeight.getSelection(), RackOrientation.getByValue((int)this.rackOrientation.getSelectionIndex()));
                md.setChassisPlacement("");
            } else {
                md.setRackPlacement(NXCommon.EMPTY_GUID, NXCommon.EMPTY_GUID, (short)0, (short)0, RackOrientation.getByValue((int)0));
                ChassisPlacement placement = new ChassisPlacement(this.chassisImageSelector.getImageGuid(), Integer.parseInt(this.chassisHeight.getText()), this.chassisHeightUnits.getSelectionIndex(), Integer.parseInt(this.chassisWidth.getText()), this.chassisWidthUnits.getSelectionIndex(), Integer.parseInt(this.chassisVerticalPosition.getText()), this.chassisVerticalPositionUnits.getSelectionIndex(), Integer.parseInt(this.chassisHorizontalPosition.getText()), this.chassisHorizontalPositionUnits.getSelectionIndex(), this.chassisOrientation.getSelectionIndex() + 1);
                String placementConfig = null;
                try {
                    placementConfig = placement.createXml();
                }
                catch (Exception e) {
                    logger.debug("Cannot create XML document from ChassisPlacement object", (Throwable)e);
                }
                md.setChassisPlacement(placementConfig);
            }
        } else if (this.object instanceof Chassis) {
            md.setRackPlacement(this.rackImageFrontSelector.getImageGuid(), this.rackImageRearSelector.getImageGuid(), (short)this.rackPosition.getSelection(), (short)this.rackHeight.getSelection(), RackOrientation.getByValue((int)this.rackOrientation.getSelectionIndex()));
        } else {
            md.setPhysicalContainer(0L);
            md.setRackPlacement(NXCommon.EMPTY_GUID, NXCommon.EMPTY_GUID, (short)0, (short)0, RackOrientation.getByValue((int)0));
            md.setChassisPlacement("");
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.objectSelector.setObjectId(0L);
        this.rackImageFrontSelector.setImageGuid(NXCommon.EMPTY_GUID, true);
        this.rackImageRearSelector.setImageGuid(NXCommon.EMPTY_GUID, true);
        this.rackPosition.setSelection(1);
        this.rackHeight.setSelection(1);
        this.rackOrientation.select(0);
        this.chassisImageSelector.setImageGuid(NXCommon.EMPTY_GUID, true);
        this.chassisHeight.setText("0");
        this.chassisHeightUnits.setText(VERTICAL_UNITS[0]);
        this.chassisWidth.setText("0");
        this.chassisWidthUnits.setText(HORIZONTAL_UNITS[0]);
        this.chassisVerticalPosition.setText("0");
        this.chassisVerticalPositionUnits.setText(VERTICAL_UNITS[0]);
        this.chassisHorizontalPosition.setText("0");
        this.chassisHorizontalPositionUnits.setText(HORIZONTAL_UNITS[0]);
        this.chassisOrientation.setText(CHASSIS_ORIENTATION[0]);
    }
}

