/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.MaintenanceJournalEntry;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.MaintenanceJournalEditDialog;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.helpers.MaintenanceJournalComparator;
import org.netxms.nxmc.modules.objects.views.helpers.MaintenanceJournalFilter;
import org.netxms.nxmc.modules.objects.views.helpers.MaintenanceJournalLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class MaintenanceJournalView
extends ObjectView {
    private static I18n i18n = LocalizationHelper.getI18n(MaintenanceJournalView.class);
    private static final String TABLE_CONFIG_PREFIX = "MaintenanceJournalView";
    public static final int COL_ID = 0;
    public static final int COL_OBJECT = 1;
    public static final int COL_AUHTHOR = 2;
    public static final int COL_EDITOR = 3;
    public static final int COL_DESCRIPTION = 4;
    public static final int COL_CREATE_TIME = 5;
    public static final int COL_MODIFY_TIME = 6;
    private NXCSession session;
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private MaintenanceJournalFilter filter;
    private Action actionAdd;
    private Action actionEdit;
    private int warningMessageId = 0;

    public MaintenanceJournalView() {
        super(i18n.tr("Maintenance journal"), ResourceManager.getImageDescriptor((String)"icons/object-views/maintenance_journal.png"), "MaintenanceJournal", true);
    }

    protected void createContent(Composite parent) {
        this.session = Registry.getSession();
        int[] widths = new int[]{50, 100, 100, 100, 500, 300, 300};
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Object"), i18n.tr("Author"), i18n.tr("Last edited by"), i18n.tr("Description"), i18n.tr("Creation time"), i18n.tr("Modification time")};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        MaintenanceJournalLabelProvider labelProvider = new MaintenanceJournalLabelProvider((ColumnViewer)this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator((ViewerComparator)new MaintenanceJournalComparator(labelProvider));
        this.filter = new MaintenanceJournalFilter(labelProvider);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((StructuredViewer)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)TABLE_CONFIG_PREFIX);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
    }

    private void createActions() {
        this.actionAdd = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAdd.setImageDescriptor(SharedIcons.ADD_OBJECT);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setImageDescriptor(SharedIcons.EDIT);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionAdd);
        mgr.add((IAction)this.actionEdit);
    }

    protected void onObjectChange(AbstractObject object) {
        if (object != null) {
            this.refresh();
        } else {
            this.viewer.setInput((Object)new MaintenanceJournalEntry[0]);
        }
    }

    public void refresh() {
        long objectId = this.getObjectId();
        if (objectId == 0L) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    private void addEntry() {
        MaintenanceJournalEditDialog dlg = new MaintenanceJournalEditDialog(this.getWindow().getShell(), this.session.getObjectName(this.getObjectId()), null);
        if (dlg.open() != 0) {
            return;
        }
        String description = dlg.getDescription();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editEntry() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        MaintenanceJournalEntry me = (MaintenanceJournalEntry)selection.getFirstElement();
        MaintenanceJournalEditDialog dlg = new MaintenanceJournalEditDialog(this.getWindow().getShell(), this.session.getObjectName(me.getObjectId()), me.getDescription());
        if (dlg.open() != 0) {
            return;
        }
        String description = dlg.getDescription();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForContext(Object context) {
        return context != null && (context instanceof DataCollectionTarget || context instanceof Container);
    }
}

