/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.xnap.commons.i18n.I18n;

public class Connection
extends OverviewPageElement {
    private static final I18n i18n = LocalizationHelper.getI18n(Connection.class);
    private NXCSession session = Registry.getSession();
    private CLabel nodeLabel;
    private CLabel interfaceLabel;
    private CLabel protocolLabel;
    private DecoratingObjectLabelProvider labelProvider;

    public Connection(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected Control createClientArea(Composite parent) {
        this.labelProvider = new DecoratingObjectLabelProvider();
        parent.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        area.setBackground(parent.getDisplay().getSystemColor(25));
        this.nodeLabel = new CLabel(area, 0);
        this.nodeLabel.setBackground(area.getBackground());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.nodeLabel.setLayoutData((Object)gd);
        this.interfaceLabel = new CLabel(area, 0);
        this.interfaceLabel.setBackground(area.getBackground());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = 15;
        this.interfaceLabel.setLayoutData((Object)gd);
        this.protocolLabel = new CLabel(area, 0);
        this.protocolLabel.setBackground(area.getBackground());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = 15;
        this.protocolLabel.setLayoutData((Object)gd);
        return area;
    }

    protected String getTitle() {
        return i18n.tr("Connection");
    }

    protected void onObjectChange() {
        if (this.getObject() == null || !(this.getObject() instanceof Interface)) {
            return;
        }
        Interface iface = (Interface)this.getObject();
        long peerNodeId = iface.getPeerNodeId();
        if (peerNodeId != 0L) {
            AbstractObject node = this.session.findObjectById(peerNodeId);
            this.nodeLabel.setText((String)(node != null ? node.getObjectName() : "<" + peerNodeId + ">"));
            this.nodeLabel.setImage(this.labelProvider.getImage((Object)node));
        } else {
            this.nodeLabel.setText(i18n.tr("N/A"));
        }
        long peerInterfaceId = iface.getPeerInterfaceId();
        if (peerInterfaceId != 0L) {
            AbstractObject peerIface = this.session.findObjectById(peerInterfaceId);
            this.interfaceLabel.setText((String)(peerIface != null ? peerIface.getObjectName() : "<" + peerInterfaceId + ">"));
            this.interfaceLabel.setImage(this.labelProvider.getImage((Object)peerIface));
            this.protocolLabel.setText(iface.getPeerDiscoveryProtocol().toString());
        } else {
            this.interfaceLabel.setText(i18n.tr("N/A"));
            this.protocolLabel.setText("");
        }
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Interface && ((Interface)object).getPeerNodeId() != 0L;
    }
}

