/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.FdbEntry;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class FDBFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private static final I18n i18n = LocalizationHelper.getI18n(FDBFilter.class);
    private static final String TYPE_MATCH_DYNAMIC = i18n.tr("Dynamic").toLowerCase();
    private static final String TYPE_MATCH_STATIC = i18n.tr("Static").toLowerCase();
    private static final String TYPE_MATCH_UNKNOWN = i18n.tr("Unknown").toLowerCase();
    private NXCSession session = Registry.getSession();
    private String filterString = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        FdbEntry en = (FdbEntry)element;
        if (this.containsMac(en)) {
            return true;
        }
        if (this.containsPort(en)) {
            return true;
        }
        if (this.containsInterface(en)) {
            return true;
        }
        if (this.containsVlan(en)) {
            return true;
        }
        if (this.containsNode(en)) {
            return true;
        }
        return this.containsType(en);
    }

    private boolean containsType(FdbEntry en) {
        switch (en.getType()) {
            case 3: {
                return TYPE_MATCH_DYNAMIC.contains(this.filterString);
            }
            case 5: {
                return TYPE_MATCH_STATIC.contains(this.filterString);
            }
        }
        return TYPE_MATCH_UNKNOWN.contains(this.filterString);
    }

    private boolean containsNode(FdbEntry en) {
        return this.session.getObjectName(en.getNodeId()).toLowerCase().contains(this.filterString);
    }

    private boolean containsVlan(FdbEntry en) {
        return Integer.toString(en.getVlanId()).toLowerCase().contains(this.filterString);
    }

    private boolean containsInterface(FdbEntry en) {
        return en.getInterfaceName().toLowerCase().contains(this.filterString);
    }

    private boolean containsPort(FdbEntry en) {
        return Integer.toString(en.getPort()).toLowerCase().contains(this.filterString);
    }

    private boolean containsMac(FdbEntry en) {
        return en.getAddress().toString().toLowerCase().contains(this.filterString);
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

