/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.MaintenanceJournalEntry;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.tools.ViewerElementUpdater;

public class MaintenanceJournalLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session = Registry.getSession();
    private ColumnViewer viewer;

    public MaintenanceJournalLabelProvider(ColumnViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        MaintenanceJournalEntry me = (MaintenanceJournalEntry)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(me.getId());
            }
            case 1: {
                return this.session.getObjectName(me.getObjectId());
            }
            case 2: {
                AbstractUserObject author = this.session.findUserDBObjectById(me.getAuthor(), (Runnable)new ViewerElementUpdater(this.viewer, element));
                return author != null ? author.getName() : "[" + Long.toString(me.getAuthor()) + "]";
            }
            case 3: {
                AbstractUserObject editor = this.session.findUserDBObjectById(me.getLastEditedBy(), (Runnable)new ViewerElementUpdater(this.viewer, element));
                return editor != null ? editor.getName() : "[" + Long.toString(me.getLastEditedBy()) + "]";
            }
            case 4: {
                return me.getDescriptionShort();
            }
            case 5: {
                return me.getCreationTime().toString();
            }
            case 6: {
                return me.getModificationTime().toString();
            }
        }
        return null;
    }
}

