/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.widgets.helpers.ObjectTreeViewer;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class ObjectStatusIndicator
extends Canvas
implements PaintListener {
    private I18n i18n = LocalizationHelper.getI18n(ObjectStatusIndicator.class);
    private ObjectTreeViewer objectTree = null;
    private boolean showIcons = false;
    private boolean hideNormal = true;
    private boolean hideUnmanaged = true;
    private boolean hideUnknown = true;
    private boolean hideDisabled = true;
    private Action actionShowIcons;
    private Action actionHideNormal;
    private Action actionHideUnmanaged;
    private Action actionHideUnknown;
    private Action actionHideDisabled;

    public ObjectStatusIndicator(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addPaintListener((PaintListener)this);
        this.setBackground(this.getDisplay().getSystemColor(25));
        PreferenceStore ps = PreferenceStore.getInstance();
        this.showIcons = ps.getAsBoolean("ObjectStatusIndicator.showIcons", false);
        this.hideNormal = ps.getAsBoolean("ObjectStatusIndicator.hideNormal", true);
        this.hideUnmanaged = ps.getAsBoolean("ObjectStatusIndicator.hideUnmanaged", true);
        this.hideUnknown = ps.getAsBoolean("ObjectStatusIndicator.hideUnknown", true);
        this.hideDisabled = ps.getAsBoolean("ObjectStatusIndicator.hideDisabled", true);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.setMenu(manager.createContextMenu((Control)this));
    }

    private void createActions() {
        this.actionShowIcons = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowIcons.setChecked(this.showIcons);
        this.actionHideDisabled = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideDisabled.setChecked(this.hideDisabled);
        this.actionHideNormal = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideNormal.setChecked(this.hideNormal);
        this.actionHideUnknown = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideUnknown.setChecked(this.hideUnknown);
        this.actionHideUnmanaged = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideUnmanaged.setChecked(this.hideUnmanaged);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowIcons);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideNormal);
        manager.add((IAction)this.actionHideUnknown);
        manager.add((IAction)this.actionHideUnmanaged);
        manager.add((IAction)this.actionHideDisabled);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(21, 10);
    }

    public void paintControl(PaintEvent e) {
        if (this.objectTree == null) {
            return;
        }
        GC gc = e.gc;
        gc.setAntialias(1);
        int width = this.getClientArea().width;
        TreeItem item = this.objectTree.getTree().getTopItem();
        if (item != null) {
            int y = 0;
            int limit = this.objectTree.getTree().getClientArea().height;
            int height = this.objectTree.getTree().getItemHeight();
            ViewerRow row = this.objectTree.getTreeViewerRow(item);
            block0: while (row != null && y < limit) {
                AbstractObject object = (AbstractObject)row.getItem().getData();
                this.drawObject(gc, object, y, width, height);
                y += height;
                if ((row = row.getNeighbor(2, false)) != null) continue;
                for (int i = 16; i < 192; i += 16) {
                    item = this.objectTree.getTree().getItem(new Point(y, y + height / 2));
                    if (item == null) continue;
                    row = this.objectTree.getTreeViewerRow(item);
                    continue block0;
                }
            }
        }
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawLine(width - 1, 0, width - 1, this.getClientArea().height);
    }

    private void drawObject(GC gc, AbstractObject object, int y, int width, int height) {
        ObjectStatus status = object.getStatus();
        if (status == ObjectStatus.NORMAL && this.hideNormal) {
            return;
        }
        if (status == ObjectStatus.UNMANAGED && this.hideUnmanaged) {
            return;
        }
        if (status == ObjectStatus.UNKNOWN && this.hideUnknown) {
            return;
        }
        if (status == ObjectStatus.DISABLED && this.hideDisabled) {
            return;
        }
        if (this.showIcons) {
            gc.drawImage(StatusDisplayInfo.getStatusImage((ObjectStatus)status), (width - 16) / 2, y + (height - 16) / 2);
        } else {
            gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)status));
            gc.setForeground(StatusDisplayInfo.getStatusColor((ObjectStatus)status));
            int size = Math.min(width - 8, height - 8);
            gc.setAlpha(127);
            gc.fillOval((width - size) / 2, y + (height - size) / 2, size, size);
            gc.setAlpha(255);
            gc.drawOval((width - size) / 2, y + (height - size) / 2, size, size);
        }
    }

    public void refresh(ObjectTreeViewer objectTree) {
        this.objectTree = objectTree;
        this.redraw();
    }
}

