/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.EntireNetwork;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.FilterText;
import org.netxms.nxmc.modules.objects.ObjectOpenListener;
import org.netxms.nxmc.modules.objects.widgets.ObjectStatusIndicator;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.ObjectFilter;
import org.netxms.nxmc.modules.objects.widgets.helpers.ObjectTreeComparator;
import org.netxms.nxmc.modules.objects.widgets.helpers.ObjectTreeContentProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.ObjectTreeViewer;
import org.netxms.nxmc.tools.RefreshTimer;

/*
 * Exception performing whole class analysis ignored.
 */
public class ObjectTree
extends Composite {
    public static final int NONE = 0;
    public static final int CHECKBOXES = 1;
    public static final int MULTI = 2;
    private View view;
    private ObjectTreeViewer objectTree;
    private FilterText filterText;
    private ObjectFilter filter;
    private Set<Long> checkedObjects = new HashSet(0);
    private SessionListener sessionListener = null;
    private NXCSession session = null;
    private RefreshTimer refreshTimer;
    private ObjectStatusIndicator statusIndicator = null;
    private SelectionListener statusIndicatorSelectionListener = null;
    private TreeListener statusIndicatorTreeListener;
    private Set<ObjectOpenListener> openListeners = new HashSet(0);
    private ObjectTreeContentProvider contentProvider;
    private boolean filterEnabled = true;
    private boolean statusIndicatorEnabled = false;
    private boolean objectsFullySync;

    public ObjectTree(Composite parent, int style, int options, Set<Integer> classFilter, View view, boolean showFilterToolTip, boolean showFilterCloseButton) {
        super(parent, style);
        String tooltip;
        this.view = view;
        PreferenceStore store = PreferenceStore.getInstance();
        this.objectsFullySync = store.getAsBoolean("ObjectBrowser.FullSync", false);
        this.session = Registry.getSession();
        this.refreshTimer = new RefreshTimer(this.session.getMinViewRefreshInterval(), (Control)this, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        String string = tooltip = showFilterToolTip ? " > - Search by IP address part \n ^ - Search by exact IP address \n # - Search by ID \n / - Search by comment \n @ - Search by Zone ID" : null;
        if (view != null) {
            view.addFilterModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            view.setFilterTooltip(tooltip);
        } else {
            this.filterText = new FilterText((Composite)this, 0, tooltip, showFilterCloseButton);
            this.filterText.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
            this.filterText.setCloseAction((Action)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.setupFilterText(true);
        this.objectTree = new ObjectTreeViewer((Composite)this, 0x10000000 | ((options & 2) == 2 ? 2 : 4) | ((options & 1) == 1 ? 32 : 0), this.objectsFullySync);
        this.objectTree.setUseHashlookup(true);
        this.contentProvider = new ObjectTreeContentProvider(this.objectsFullySync, classFilter);
        this.objectTree.setContentProvider((IContentProvider)this.contentProvider);
        this.objectTree.setLabelProvider((IBaseLabelProvider)new DecoratingObjectLabelProvider());
        this.objectTree.setComparator((ViewerComparator)new ObjectTreeComparator());
        this.filter = new ObjectFilter(null, classFilter);
        this.objectTree.addFilter((ViewerFilter)this.filter);
        this.objectTree.setInput((Object)this.session);
        this.objectTree.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.objectTree.getControl().addListener(13, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = this.filterText != null ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.getTree().setLayoutData((Object)fd);
        if (this.filterText != null) {
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            this.filterText.setLayoutData((Object)fd);
        }
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.filterEnabled && this.filterText != null) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.enableStatusIndicator(this.statusIndicatorEnabled);
    }

    public void enableDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.objectTree.addDragSupport(3, transfers, (DragSourceListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setupFilterText(boolean addListener) {
        FilterText filterText;
        FilterText filterText2 = filterText = this.view != null ? this.view.getFilterTextControl() : this.filterText;
        if (filterText == null) {
            return;
        }
        PreferenceStore ps = PreferenceStore.getInstance();
        if (ps.getAsBoolean("ObjectBrowser.UseServerFilterSettings", true)) {
            filterText.setAutoApply(this.session.getClientConfigurationHintAsBoolean("ObjectBrowser.AutoApplyFilter", true));
            filterText.setDelay(this.session.getClientConfigurationHintAsInt("ObjectBrowser.FilterDelay", 300));
            filterText.setMinLength(this.session.getClientConfigurationHintAsInt("ObjectBrowser.MinFilterStringLength", 1));
        } else {
            filterText.setAutoApply(ps.getAsBoolean("ObjectBrowser.AutoApplyFilter", true));
            filterText.setDelay(ps.getAsInteger("ObjectBrowser.FilterDelay", 300));
            filterText.setMinLength(ps.getAsInteger("ObjectBrowser.MinFilterStringLength", 1));
        }
        if (addListener) {
            ps.addPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public Tree getTreeControl() {
        return this.objectTree.getTree();
    }

    public TreeViewer getTreeViewer() {
        return this.objectTree;
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        if (this.filterText == null) {
            return;
        }
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.objectTree.getTree().getLayoutData();
        FormAttachment formAttachment = fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        if (this.statusIndicatorEnabled) {
            fd = (FormData)this.statusIndicator.getLayoutData();
            fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        }
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilterText("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterText(String text) {
        if (this.view != null) {
            this.view.setFilterText(text);
        } else {
            this.filterText.setText(text);
        }
        this.onFilterModify();
    }

    public String getFilterText() {
        return this.view != null ? this.view.getFilterText() : this.filterText.getText();
    }

    public Long[] getCheckedObjects() {
        return this.checkedObjects.toArray(new Long[this.checkedObjects.size()]);
    }

    public long getFirstSelectedObject() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        if (selection.isEmpty()) {
            return 0L;
        }
        return ((AbstractObject)selection.getFirstElement()).getObjectId();
    }

    public Long[] getSelectedObjects() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        HashSet<Long> objects = new HashSet<Long>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            objects.add(((AbstractObject)it.next()).getObjectId());
        }
        return objects.toArray(new Long[objects.size()]);
    }

    public AbstractObject getFirstSelectedObject2() {
        IStructuredSelection selection = (IStructuredSelection)this.objectTree.getSelection();
        return (AbstractObject)selection.getFirstElement();
    }

    public void refresh() {
        this.objectTree.setInput((Object)this.session);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.objectTree.getControl().setEnabled(enabled);
        if (this.filterText != null) {
            this.filterText.setEnabled(enabled);
        }
    }

    private void onFilterModify() {
        String text = this.getFilterText();
        this.filter.setFilterString(text);
        AbstractObject obj = this.filter.getLastMatch();
        if (obj != null) {
            AbstractObject parent = this.getParent(obj);
            if (parent != null) {
                this.objectTree.expandToLevel((Object)parent, 1);
            }
            this.objectTree.setSelection((ISelection)new StructuredSelection((Object)obj), true);
            this.objectTree.reveal((Object)obj);
            if (this.statusIndicatorEnabled) {
                this.updateStatusIndicator();
            }
        }
        this.objectTree.refresh(false);
    }

    static int getParentPriority(AbstractObject object) {
        if (object instanceof ServiceRoot || object instanceof EntireNetwork) {
            return 3;
        }
        if (object instanceof Container || object instanceof Cluster || object instanceof Chassis || object instanceof Rack) {
            return 2;
        }
        if (object instanceof Zone || object instanceof Subnet) {
            return 1;
        }
        return 0;
    }

    private AbstractObject getParent(AbstractObject childObject) {
        AbstractObject[] parents = childObject.getParentsAsArray();
        AbstractObject parent = null;
        int parentPriority = -1;
        for (AbstractObject p : parents) {
            int pp = ObjectTree.getParentPriority((AbstractObject)p);
            if (pp <= parentPriority) continue;
            parentPriority = pp;
            parent = p;
        }
        return parent;
    }

    public boolean isHideUnmanaged() {
        return this.filter.isHideUnmanaged();
    }

    public void setHideUnmanaged(boolean hide) {
        this.filter.setHideUnmanaged(hide);
        this.onFilterModify();
    }

    public boolean isHideTemplateChecks() {
        return this.filter.isHideTemplateChecks();
    }

    public void setHideTemplateChecks(boolean hide) {
        this.filter.setHideTemplateChecks(hide);
        this.onFilterModify();
    }

    public boolean isHideSubInterfaces() {
        return this.filter.isHideSubInterfaces();
    }

    public void setHideSubInterfaces(boolean hide) {
        this.filter.setHideSubInterfaces(hide);
        this.onFilterModify();
    }

    public void setFilterCloseAction(Action action) {
        if (this.filterText != null) {
            this.filterText.setCloseAction(action);
        }
    }

    public void enableStatusIndicator(boolean enabled) {
        if (this.statusIndicatorEnabled == enabled) {
            return;
        }
        this.statusIndicatorEnabled = enabled;
        if (enabled) {
            this.statusIndicator = new ObjectStatusIndicator((Composite)this, 0);
            FormData fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = this.filterEnabled && this.filterText != null ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
            fd.bottom = new FormAttachment(100, 0);
            this.statusIndicator.setLayoutData((Object)fd);
            fd = (FormData)this.objectTree.getTree().getLayoutData();
            fd.left = new FormAttachment((Control)this.statusIndicator);
            this.statusIndicatorSelectionListener = new /* Unavailable Anonymous Inner Class!! */;
            this.objectTree.getTree().getVerticalBar().addSelectionListener(this.statusIndicatorSelectionListener);
            this.statusIndicatorTreeListener = new /* Unavailable Anonymous Inner Class!! */;
            this.objectTree.getTree().addTreeListener(this.statusIndicatorTreeListener);
            this.updateStatusIndicator();
        } else {
            this.objectTree.getTree().getVerticalBar().removeSelectionListener(this.statusIndicatorSelectionListener);
            this.objectTree.getTree().removeTreeListener(this.statusIndicatorTreeListener);
            this.statusIndicator.dispose();
            this.statusIndicator = null;
            this.statusIndicatorSelectionListener = null;
            this.statusIndicatorTreeListener = null;
            FormData fd = (FormData)this.objectTree.getTree().getLayoutData();
            fd.left = new FormAttachment(0, 0);
        }
        this.layout(true, true);
    }

    public boolean isStatusIndicatorEnabled() {
        return this.statusIndicatorEnabled;
    }

    private void updateStatusIndicator() {
        this.statusIndicator.refresh(this.objectTree);
    }

    public void addOpenListener(ObjectOpenListener listener) {
        this.openListeners.add(listener);
    }

    public void removeOpenListener(ObjectOpenListener listener) {
        this.openListeners.remove(listener);
    }

    private boolean openObject(AbstractObject object) {
        for (ObjectOpenListener l : this.openListeners) {
            if (!l.openObject(object)) continue;
            return true;
        }
        return false;
    }

    public void disableRefresh() {
        this.refreshTimer.disableRefresh();
    }

    public void enableRefresh() {
        this.refreshTimer.enableRefresh();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.objectTree;
    }
}

