/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.objects.widgets.helpers.ObjectTreeViewer;

public class ObjectTreeViewer
extends TreeViewer {
    private NXCSession session = Registry.getSession();
    private boolean objectsFullySync;

    public ObjectTreeViewer(Composite parent, int style, boolean objectsFullySync) {
        super(parent, style);
        this.objectsFullySync = objectsFullySync;
        this.setComparer((IElementComparer)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ViewerRow getTreeViewerRow(TreeItem item) {
        return this.getViewerRowFromItem((Widget)item);
    }

    public void toggleItemExpandState(TreeItem item) {
        if (item.getExpanded()) {
            item.setExpanded(false);
        } else {
            this.checkAndSyncChildren((AbstractObject)item.getData());
            this.createChildren((Widget)item);
            item.setExpanded(true);
        }
    }

    protected void handleTreeExpand(TreeEvent event) {
        this.checkAndSyncChildren((AbstractObject)event.item.getData());
        super.handleTreeExpand(event);
    }

    private void checkAndSyncChildren(AbstractObject object) {
        if (!this.objectsFullySync && object instanceof Node && object.hasChildren() && !this.session.areChildrenSynchronized(object.getObjectId())) {
            this.syncChildren(object);
        }
    }

    private void syncChildren(AbstractObject object) {
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }
}

