/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.resources;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorCache;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public final class StatusDisplayInfo {
    private static I18n i18n = LocalizationHelper.getI18n(StatusDisplayInfo.class);
    private static String[] statusText = new String[9];
    private static ImageDescriptor[] statusImageDescriptors = new ImageDescriptor[9];
    private static Image[] statusImages = new Image[9];
    private static ImageDescriptor[] overlayImageDescriptors = new ImageDescriptor[9];
    private static ColorCache colorCache;
    private static Color[] statusColor;

    public static void init(Display display) {
        StatusDisplayInfo.statusText[ObjectStatus.NORMAL.getValue()] = i18n.tr("Normal");
        StatusDisplayInfo.statusText[ObjectStatus.WARNING.getValue()] = i18n.tr("Warning");
        StatusDisplayInfo.statusText[ObjectStatus.MINOR.getValue()] = i18n.tr("Minor");
        StatusDisplayInfo.statusText[ObjectStatus.MAJOR.getValue()] = i18n.tr("Major");
        StatusDisplayInfo.statusText[ObjectStatus.CRITICAL.getValue()] = i18n.tr("Critical");
        StatusDisplayInfo.statusText[ObjectStatus.UNKNOWN.getValue()] = i18n.tr("Unknown");
        StatusDisplayInfo.statusText[ObjectStatus.UNMANAGED.getValue()] = i18n.tr("Unmanaged");
        StatusDisplayInfo.statusText[ObjectStatus.DISABLED.getValue()] = i18n.tr("Disabled");
        StatusDisplayInfo.statusText[ObjectStatus.TESTING.getValue()] = i18n.tr("Testing");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.NORMAL.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/normal.png");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.WARNING.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/warning.png");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.MINOR.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/minor.png");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.MAJOR.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/major.png");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.CRITICAL.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/critical.png");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.UNKNOWN.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/unknown.png");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.UNMANAGED.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/unmanaged.png");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.DISABLED.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/disabled.png");
        StatusDisplayInfo.statusImageDescriptors[ObjectStatus.TESTING.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/testing.png");
        for (int i = 0; i < statusImageDescriptors.length; ++i) {
            StatusDisplayInfo.statusImages[i] = statusImageDescriptors[i].createImage();
        }
        StatusDisplayInfo.overlayImageDescriptors[ObjectStatus.WARNING.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/warning.png");
        StatusDisplayInfo.overlayImageDescriptors[ObjectStatus.MINOR.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/minor.png");
        StatusDisplayInfo.overlayImageDescriptors[ObjectStatus.MAJOR.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/major.png");
        StatusDisplayInfo.overlayImageDescriptors[ObjectStatus.CRITICAL.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/critical.png");
        StatusDisplayInfo.overlayImageDescriptors[ObjectStatus.UNKNOWN.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/unknown.gif");
        StatusDisplayInfo.overlayImageDescriptors[ObjectStatus.UNMANAGED.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/unmanaged.gif");
        StatusDisplayInfo.overlayImageDescriptors[ObjectStatus.DISABLED.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/disabled.gif");
        StatusDisplayInfo.overlayImageDescriptors[ObjectStatus.TESTING.getValue()] = ResourceManager.getImageDescriptor((String)"icons/status/overlay/testing.png");
        colorCache = new ColorCache();
        StatusDisplayInfo.updateStatusColors();
    }

    public static void updateStatusColors() {
        PreferenceStore ps = PreferenceStore.getInstance();
        StatusDisplayInfo.statusColor[0] = colorCache.create(ps.getAsColor("Status.Colors.Normal", ThemeEngine.getForegroundColorDefinition((String)"Status.Normal")));
        StatusDisplayInfo.statusColor[1] = colorCache.create(ps.getAsColor("Status.Colors.Warning", ThemeEngine.getForegroundColorDefinition((String)"Status.Warning")));
        StatusDisplayInfo.statusColor[2] = colorCache.create(ps.getAsColor("Status.Colors.Minor", ThemeEngine.getForegroundColorDefinition((String)"Status.Minor")));
        StatusDisplayInfo.statusColor[3] = colorCache.create(ps.getAsColor("Status.Colors.Major", ThemeEngine.getForegroundColorDefinition((String)"Status.Major")));
        StatusDisplayInfo.statusColor[4] = colorCache.create(ps.getAsColor("Status.Colors.Critical", ThemeEngine.getForegroundColorDefinition((String)"Status.Critical")));
        StatusDisplayInfo.statusColor[5] = colorCache.create(ps.getAsColor("Status.Colors.Unknown", ThemeEngine.getForegroundColorDefinition((String)"Status.Unknown")));
        StatusDisplayInfo.statusColor[6] = colorCache.create(ps.getAsColor("Status.Colors.Unmanaged", ThemeEngine.getForegroundColorDefinition((String)"Status.Unmanaged")));
        StatusDisplayInfo.statusColor[7] = colorCache.create(ps.getAsColor("Status.Colors.Disabled", ThemeEngine.getForegroundColorDefinition((String)"Status.Disabled")));
        StatusDisplayInfo.statusColor[8] = colorCache.create(ps.getAsColor("Status.Colors.Testing", ThemeEngine.getForegroundColorDefinition((String)"Status.Testing")));
    }

    public static String getStatusText(ObjectStatus status) {
        return statusText[status.getValue()];
    }

    public static String getStatusText(Severity severity) {
        return statusText[severity.getValue()];
    }

    public static String getStatusText(int code) {
        return StatusDisplayInfo.getStatusText((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    public static ImageDescriptor getStatusImageDescriptor(ObjectStatus status) {
        return statusImageDescriptors[status.getValue()];
    }

    public static ImageDescriptor getStatusImageDescriptor(Severity severity) {
        return statusImageDescriptors[severity.getValue()];
    }

    public static ImageDescriptor getStatusImageDescriptor(int code) {
        return StatusDisplayInfo.getStatusImageDescriptor((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    public static Image getStatusImage(ObjectStatus status) {
        return statusImages[status.getValue()];
    }

    public static Image getStatusImage(int code) {
        return StatusDisplayInfo.getStatusImage((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    public static Image getStatusImage(Severity severity) {
        return statusImages[severity.getValue()];
    }

    public static ImageDescriptor getStatusOverlayImageDescriptor(ObjectStatus status) {
        return overlayImageDescriptors[status.getValue()];
    }

    public static ImageDescriptor getStatusOverlayImageDescriptor(Severity severity) {
        return overlayImageDescriptors[severity.getValue()];
    }

    public static ImageDescriptor getStatusOverlayImageDescriptor(int code) {
        return StatusDisplayInfo.getStatusOverlayImageDescriptor((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    public static Color getStatusColor(ObjectStatus status) {
        return statusColor[status.getValue()];
    }

    public static Color getStatusColor(Severity severity) {
        return statusColor[severity.getValue()];
    }

    public static Color getStatusColor(int code) {
        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.getByValue((int)code));
    }

    static {
        statusColor = new Color[9];
    }
}

