/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EventReferenceType {
    ERROR(-1),
    AGENT_POLICY(0),
    DCI(1),
    EP_RULE(2),
    SNMP_TRAP(3),
    CONDITION(4),
    SYSLOG(5),
    WINDOWS_EVENT_LOG(6);

    private static Logger logger;
    private static Map<Integer, EventReferenceType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(EventReferenceType.class);
        lookupTable = new HashMap<Integer, EventReferenceType>();
        EventReferenceType[] eventReferenceTypeArray = EventReferenceType.values();
        int n = eventReferenceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventReferenceType element = eventReferenceTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private EventReferenceType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static EventReferenceType getByValue(int value) {
        EventReferenceType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return ERROR;
        }
        return element;
    }
}

