/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.CollectionUtil;

public class ConjunctionDISI
extends DocIdSetIterator {
    final DocIdSetIterator lead;
    final DocIdSetIterator[] others;

    public static ConjunctionDISI intersectScorers(List<Scorer> scorers) {
        if (scorers.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (Scorer scorer : scorers) {
            ConjunctionDISI.addScorer(scorer, allIterators, twoPhaseIterators);
        }
        if (twoPhaseIterators.isEmpty()) {
            return new ConjunctionDISI(allIterators);
        }
        return new TwoPhase(allIterators, twoPhaseIterators);
    }

    public static ConjunctionDISI intersectIterators(List<DocIdSetIterator> iterators) {
        if (iterators.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (DocIdSetIterator iterator : iterators) {
            ConjunctionDISI.addIterator(iterator, allIterators, twoPhaseIterators);
        }
        if (twoPhaseIterators.isEmpty()) {
            return new ConjunctionDISI(allIterators);
        }
        return new TwoPhase(allIterators, twoPhaseIterators);
    }

    public static ConjunctionDISI intersectSpans(List<Spans> spanList) {
        if (spanList.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        ArrayList<TwoPhaseIterator> twoPhaseIterators = new ArrayList<TwoPhaseIterator>();
        for (Spans spans : spanList) {
            ConjunctionDISI.addSpans(spans, allIterators, twoPhaseIterators);
        }
        if (twoPhaseIterators.isEmpty()) {
            return new ConjunctionDISI(allIterators);
        }
        return new TwoPhase(allIterators, twoPhaseIterators);
    }

    private static void addScorer(Scorer scorer, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        TwoPhaseIterator twoPhaseIter = scorer.twoPhaseIterator();
        if (twoPhaseIter != null) {
            ConjunctionDISI.addTwoPhaseIterator(twoPhaseIter, allIterators, twoPhaseIterators);
        } else {
            ConjunctionDISI.addIterator(scorer.iterator(), allIterators, twoPhaseIterators);
        }
    }

    private static void addSpans(Spans spans, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        TwoPhaseIterator twoPhaseIter = spans.asTwoPhaseIterator();
        if (twoPhaseIter != null) {
            ConjunctionDISI.addTwoPhaseIterator(twoPhaseIter, allIterators, twoPhaseIterators);
        } else {
            ConjunctionDISI.addIterator(spans, allIterators, twoPhaseIterators);
        }
    }

    private static void addIterator(DocIdSetIterator disi, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        if (disi.getClass() == ConjunctionDISI.class || disi.getClass() == TwoPhase.class) {
            ConjunctionDISI conjunction = (ConjunctionDISI)disi;
            allIterators.add(conjunction.lead);
            Collections.addAll(allIterators, conjunction.others);
            if (conjunction.getClass() == TwoPhase.class) {
                TwoPhase twoPhase = (TwoPhase)conjunction;
                Collections.addAll(twoPhaseIterators, twoPhase.twoPhaseView.twoPhaseIterators);
            }
        } else {
            allIterators.add(disi);
        }
    }

    private static void addTwoPhaseIterator(TwoPhaseIterator twoPhaseIter, List<DocIdSetIterator> allIterators, List<TwoPhaseIterator> twoPhaseIterators) {
        ConjunctionDISI.addIterator(twoPhaseIter.approximation(), allIterators, twoPhaseIterators);
        twoPhaseIterators.add(twoPhaseIter);
    }

    ConjunctionDISI(List<? extends DocIdSetIterator> iterators) {
        assert (iterators.size() >= 2);
        CollectionUtil.timSort(iterators, new Comparator<DocIdSetIterator>(){

            @Override
            public int compare(DocIdSetIterator o1, DocIdSetIterator o2) {
                return Long.compare(o1.cost(), o2.cost());
            }
        });
        this.lead = iterators.get(0);
        this.others = iterators.subList(1, iterators.size()).toArray(new DocIdSetIterator[0]);
    }

    protected boolean matches() throws IOException {
        return true;
    }

    TwoPhaseIterator asTwoPhaseIterator() {
        return null;
    }

    private int doNext(int doc) throws IOException {
        block0: while (doc != Integer.MAX_VALUE) {
            for (DocIdSetIterator other : this.others) {
                int next;
                if (other.docID() >= doc || (next = other.advance(doc)) <= doc) continue;
                doc = this.lead.advance(next);
                continue block0;
            }
            if (this.matches()) {
                return doc;
            }
            doc = this.lead.nextDoc();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int advance(int target) throws IOException {
        return this.doNext(this.lead.advance(target));
    }

    @Override
    public int docID() {
        return this.lead.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.doNext(this.lead.nextDoc());
    }

    @Override
    public long cost() {
        return this.lead.cost();
    }

    private static class TwoPhase
    extends ConjunctionDISI {
        final TwoPhaseConjunctionDISI twoPhaseView;

        private TwoPhase(List<? extends DocIdSetIterator> iterators, List<TwoPhaseIterator> twoPhaseIterators) {
            super(iterators);
            this.twoPhaseView = new TwoPhaseConjunctionDISI(iterators, twoPhaseIterators);
        }

        @Override
        public TwoPhaseConjunctionDISI asTwoPhaseIterator() {
            return this.twoPhaseView;
        }

        @Override
        protected boolean matches() throws IOException {
            return this.twoPhaseView.matches();
        }
    }

    private static class TwoPhaseConjunctionDISI
    extends TwoPhaseIterator {
        private final TwoPhaseIterator[] twoPhaseIterators;
        private final float matchCost;

        private TwoPhaseConjunctionDISI(List<? extends DocIdSetIterator> iterators, List<TwoPhaseIterator> twoPhaseIterators) {
            super(new ConjunctionDISI(iterators));
            assert (twoPhaseIterators.size() > 0);
            CollectionUtil.timSort(twoPhaseIterators, new Comparator<TwoPhaseIterator>(){

                @Override
                public int compare(TwoPhaseIterator o1, TwoPhaseIterator o2) {
                    return Float.compare(o1.matchCost(), o2.matchCost());
                }
            });
            this.twoPhaseIterators = twoPhaseIterators.toArray(new TwoPhaseIterator[twoPhaseIterators.size()]);
            float totalMatchCost = 0.0f;
            for (TwoPhaseIterator tpi : twoPhaseIterators) {
                totalMatchCost += tpi.matchCost();
            }
            this.matchCost = totalMatchCost;
        }

        @Override
        public boolean matches() throws IOException {
            for (TwoPhaseIterator twoPhaseIterator : this.twoPhaseIterators) {
                if (twoPhaseIterator.matches()) continue;
                return false;
            }
            return true;
        }

        @Override
        public float matchCost() {
            return this.matchCost;
        }
    }
}

