/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.viewers.internal;

import org.eclipse.gef4.zest.core.viewers.AbstractStructuredGraphViewer;
import org.eclipse.gef4.zest.core.viewers.EntityConnectionData;
import org.eclipse.gef4.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class TreeModelEntityFactory
extends AbstractStylingModelFactory {
    AbstractStructuredGraphViewer viewer = null;

    public TreeModelEntityFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    @Override
    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    @Override
    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object inputElement = this.getViewer().getInput();
        ITreeContentProvider provider = (ITreeContentProvider)this.getContentProvider();
        Object[] entities = provider.getElements(inputElement);
        if (entities == null) {
            return;
        }
        Object[] objectArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Object data = objectArray[n2];
            this.createGraphNodes(model, data, provider);
            ++n2;
        }
    }

    private GraphNode createGraphNodes(Graph model, Object data, ITreeContentProvider provider) {
        GraphNode node = this.createNode(model, data);
        if (provider.hasChildren(data)) {
            Object[] objectArray = provider.getChildren(data);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                GraphNode childNode = this.createGraphNodes(model, child, provider);
                EntityConnectionData connectionData = new EntityConnectionData(node, childNode);
                this.createConnection(model, connectionData, data, child);
                ++n2;
            }
        }
        return node;
    }

    @Override
    public void refresh(Graph graph, Object element, boolean updateLabels) {
        GraphConnection conn;
        if (element == null) {
            return;
        }
        GraphNode node = this.viewer.getGraphModelNode(element);
        if (node == null && (conn = this.viewer.getGraphModelConnection(element)) != null) {
            this.refresh(graph, conn.getSource().getData(), updateLabels);
            this.refresh(graph, conn.getDestination().getData(), updateLabels);
            return;
        }
        if (node == null) {
            return;
        }
        this.reconnect(graph, element, updateLabels);
        if (updateLabels) {
            this.update((GraphItem)node);
        }
    }

    private void reconnect(Graph graph, Object element, boolean updateLabels) {
        GraphNode sourceNode = this.viewer.getGraphModelNode(element);
        Object[] children = ((ITreeContentProvider)this.getContentProvider()).getChildren(element);
        EntityConnectionData data = null;
        GraphConnection oldConnection = null;
        GraphConnection newConnection = null;
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            GraphNode destNode = this.viewer.getGraphModelNode(child);
            data = new EntityConnectionData(sourceNode, destNode);
            oldConnection = this.viewer.getGraphModelConnection(data);
            if (oldConnection != null) {
                this.viewer.removeGraphModelConnection(oldConnection);
                newConnection = this.createConnection(graph, data, sourceNode.getData(), destNode.getData());
                if (updateLabels) {
                    this.styleItem((GraphItem)newConnection);
                }
            }
            this.refresh(graph, child, updateLabels);
            ++n2;
        }
    }
}

