/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.netxms.base.MacAddress;
import org.netxms.base.MacAddressFormatException;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.widgets.SearchResult;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class FindByMacAddressView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.FindByMacAddressView";
    private static final String TABLE_CONFIG_PREFIX = "FindByMacAddressView";
    private SearchResult serachResultWidget;
    private Button startButton;
    private LabeledText queryEditor;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        Composite searchBar = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        searchBar.setLayout((Layout)gridLayout);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        searchBar.setLayoutData((Object)fd);
        this.queryEditor = new LabeledText(searchBar, 0);
        this.queryEditor.setLabel("Search string");
        this.queryEditor.getTextControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && e.keyCode == 13) {
                    FindByMacAddressView.this.search();
                }
            }
        });
        this.queryEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.startButton = new Button(searchBar, 8);
        this.startButton.setImage(SharedIcons.IMG_EXECUTE);
        this.startButton.setText("Start");
        this.startButton.setToolTipText("Start search");
        this.startButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindByMacAddressView.this.search();
            }
        });
        this.startButton.setLayoutData((Object)new GridData(4, 1024, false, false));
        Composite mainContent = new Composite(parent, 0);
        mainContent.setLayout((Layout)new FillLayout());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)searchBar);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        mainContent.setLayoutData((Object)fd);
        this.serachResultWidget = new SearchResult(this, mainContent, 0, TABLE_CONFIG_PREFIX);
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.serachResultWidget.fillLocalPullDown(bars.getMenuManager());
        this.serachResultWidget.fillLocalToolBar(bars.getToolBarManager());
    }

    public void setFocus() {
        this.serachResultWidget.setFocus();
    }

    public void dispose() {
        super.dispose();
    }

    void search() {
        MacAddress macAddress;
        final String macAddr = this.queryEditor.getText();
        try {
            macAddress = MacAddress.parseMacAddress((String)macAddr, (boolean)false);
        }
        catch (MacAddressFormatException e) {
            Shell shell = this.serachResultWidget.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.EnterMacAddressDlg_Error, (String)Messages.EnterMacAddressDlg_IncorrectMacAddress);
            return;
        }
        this.startButton.setEnabled(false);
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.FindMacAddress_JobTitle, macAddr), null, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List cp = session.findConnectionPoints(macAddress.getValue(), 100);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).FindByMacAddressView.this.serachResultWidget.showConnection(cp);
                        (this).FindByMacAddressView.this.startButton.setEnabled(true);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.FindMacAddress_JobError, macAddr);
            }
        }.start();
    }
}

