/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.topology.VlanInfo;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.views.helpers.VlanLabelProvider;
import org.netxms.ui.eclipse.topology.widgets.DeviceView;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortSelectionListener;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class VlanView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.VlanView";
    public static final int COLUMN_VLAN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_PORTS = 2;
    public static final int COLUMN_INTERFACES = 3;
    private long nodeId;
    private List<VlanInfo> vlans = new ArrayList<VlanInfo>(0);
    private NXCSession session;
    private SortableTableViewer vlanList;
    private ScrolledComposite scroller;
    private DeviceView deviceView;
    private boolean refreshOnStartup = false;
    private Action actionRefresh;
    private Action actionShowVlanMap;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.nodeId = Long.parseLong(site.getSecondaryId());
        this.session = ConsoleSharedData.getSession();
        AbstractObject object = this.session.findObjectById(this.nodeId);
        Messages.get();
        this.setPartName(String.format(Messages.VlanView_PartName, object != null ? object.getObjectName() : "<" + site.getSecondaryId() + ">"));
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.refreshOnStartup = true;
        }
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.VlanView_ColumnID;
        Messages.get();
        stringArray[1] = Messages.VlanView_ColumnName;
        Messages.get();
        stringArray[2] = Messages.VlanView_ColumnPorts;
        stringArray[3] = "Interfaces";
        String[] names = stringArray;
        int[] widths = new int[]{80, 180, 400, 400};
        this.vlanList = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.vlanList.setContentProvider((IContentProvider)new ArrayContentProvider());
        final VlanLabelProvider labelProvider = new VlanLabelProvider();
        this.vlanList.setLabelProvider((IBaseLabelProvider)labelProvider);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.vlanList.getTable().setLayoutData((Object)gd);
        this.vlanList.setInput((Object)this.vlans.toArray());
        this.vlanList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)VlanView.this.vlanList.getSelection();
                VlanInfo vlan = (VlanInfo)selection.getFirstElement();
                if (vlan != null) {
                    VlanView.this.deviceView.setHighlight(vlan.getPorts());
                    VlanView.this.actionShowVlanMap.setEnabled(true);
                } else {
                    VlanView.this.deviceView.clearHighlight(true);
                    VlanView.this.actionShowVlanMap.setEnabled(false);
                }
                if (labelProvider.setSelectedPort(null)) {
                    VlanView.this.vlanList.refresh();
                }
            }
        });
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.vlanList, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"VlanList");
        this.vlanList.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)VlanView.this.vlanList, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"VlanList");
            }
        });
        Composite deviceViewArea = new Composite(parent, 0);
        deviceViewArea.setLayout((Layout)new FillLayout());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        deviceViewArea.setLayoutData((Object)gd);
        this.scroller = new ScrolledComposite(deviceViewArea, 768);
        this.deviceView = new DeviceView((Composite)this.scroller, 0);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.deviceView.setLayoutData(gd);
        this.deviceView.setPortStatusVisible(false);
        this.deviceView.setNodeId(this.nodeId);
        this.deviceView.addSelectionListener(new PortSelectionListener(){

            @Override
            public void portSelected(PortInfo port) {
                VlanView.this.vlanList.setSelection(null);
                labelProvider.setSelectedPort(port);
                VlanView.this.vlanList.refresh();
            }
        });
        this.scroller.setContent((Control)this.deviceView);
        this.scroller.setBackground(this.deviceView.getBackground());
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                VlanView.this.scroller.setMinSize(VlanView.this.deviceView.computeSize(-1, -1));
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        if (this.refreshOnStartup) {
            this.refreshVlanList();
        }
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                VlanView.this.refreshVlanList();
            }
        };
        Messages.get();
        this.actionShowVlanMap = new Action(Messages.VlanView_ShowVlanMap){

            public void run() {
                VlanView.this.showVlanMap();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.vlanList, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.vlanList, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowVlanMap);
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                VlanView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.vlanList.getControl());
        this.vlanList.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.vlanList);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.vlanList);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowVlanMap);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.vlanList.getControl().setFocus();
    }

    public void setVlans(List<VlanInfo> vlans) {
        this.vlans = vlans;
        this.vlanList.setInput((Object)vlans.toArray());
    }

    private void showVlanMap() {
        IStructuredSelection selection = (IStructuredSelection)this.vlanList.getSelection();
        IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
        for (Object o : selection.toList()) {
            VlanInfo vlan = (VlanInfo)o;
            try {
                page.showView("org.netxms.ui.eclipse.networkmaps.views.VlanMap", String.valueOf(Long.toString(this.nodeId)) + "&" + Integer.toString(vlan.getVlanId()), 1);
            }
            catch (PartInitException e) {
                Shell shell = this.getSite().getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.VlanView_Error, (String)String.format(Messages.VlanView_OpenMapError, vlan.getVlanId(), e.getLocalizedMessage()));
            }
        }
    }

    private void refreshVlanList() {
        Messages.get();
        new ConsoleJob(Messages.VlanView_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List vlans = VlanView.this.session.getVlans(VlanView.this.nodeId);
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        VlanView.this.setVlans(vlans);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.VlanView_JobError;
            }
        }.start();
    }
}

