/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AccessListLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ElementLabelComparator;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;

public class AccessControl
extends AbstractDCIPropertyPage {
    private DataCollectionObject dco;
    private Set<AbstractUserObject> acl = new HashSet<AbstractUserObject>();
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonRemove;
    private static final String[] info = new String[]{"Inherited from object access rights"};
    private NXCSession session;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dco = this.editor.getObject();
        Platform.getAdapterManager().loadAdapter((Object)new User(""), "org.eclipse.ui.model.IWorkbenchAdapter");
        this.session = ConsoleSharedData.getSession();
        for (Long uid : this.dco.getAccessList()) {
            AbstractUserObject o = this.session.findUserDBObjectById(uid.longValue(), null);
            if (o == null) continue;
            this.acl.add(o);
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText("Restrict access to the following users");
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AccessListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.getTable().setSortDirection(128);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.setViewerInput();
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText("Add");
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AccessControl.this.addUser();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText("Remove");
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                AccessControl.this.removeUsers();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.getUsersAndRefresh();
        return dialogArea;
    }

    private void getUsersAndRefresh() {
        ConsoleJob job = new ConsoleJob("Synchronize node components", null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (AccessControl.this.session.syncMissingUsers(new HashSet(AccessControl.this.dco.getAccessList()))) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (Long uid : (this).AccessControl.this.dco.getAccessList()) {
                                AbstractUserObject o = (this).AccessControl.this.session.findUserDBObjectById(uid.longValue(), null);
                                if (o == null) continue;
                                (this).AccessControl.this.acl.add(o);
                            }
                            AccessControl.this.setViewerInput();
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot synchronize node components";
            }
        };
        job.setUser(false);
        job.start();
    }

    private void setViewerInput() {
        if (this.acl.isEmpty()) {
            this.viewer.setInput((Object)info);
        } else {
            this.viewer.setInput((Object)this.acl.toArray());
        }
    }

    public void addUser() {
        SelectUserDialog dlg = new SelectUserDialog(this.getShell(), AbstractUserObject.class);
        if (dlg.open() == 0) {
            AbstractUserObject[] abstractUserObjectArray = dlg.getSelection();
            int n = abstractUserObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractUserObject o = abstractUserObjectArray[n2];
                this.acl.add(o);
                ++n2;
            }
            this.setViewerInput();
        }
    }

    public void removeUsers() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.acl.remove(o);
        }
        this.setViewerInput();
    }

    protected void applyChanges(boolean isApply) {
        ArrayList<Long> list = new ArrayList<Long>(this.acl.size());
        for (AbstractUserObject o : this.acl) {
            list.add(o.getId());
        }
        this.dco.setAccessList(list);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performDefaults() {
        this.acl.clear();
        this.setViewerInput();
    }
}

