/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ServerVariableDataType;
import org.netxms.client.server.ServerVariable;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Activator;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.VariableEditDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ServerVariableComparator;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ServerVariablesFilter;
import org.netxms.ui.eclipse.serverconfig.views.helpers.ServerVariablesLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ServerConfigurationEditor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.view.server_config";
    private SortableTableViewer viewer;
    private NXCSession session;
    private Map<String, ServerVariable> varList;
    private boolean initShowFilter = true;
    private Composite content;
    private FilterText filterText;
    private ServerVariablesFilter filter;
    private Action actionAdd;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionRefresh;
    private Action actionShowFilter;
    private Action actionDefaultValue;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_DEFAULT_VALUE = 2;
    public static final int COLUMN_NEED_RESTART = 3;
    public static final int COLUMN_DESCRIPTION = 4;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = ServerConfigurationEditor.safeCast(settings.get("ServerConfigurationEditor.showFilter"), settings.getBoolean("ServerConfigurationEditor.showFilter"), this.initShowFilter);
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerConfigurationEditor.this.onFilterModify();
            }
        });
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.ServerConfigurationEditor_ColName;
        Messages.get();
        stringArray[1] = Messages.ServerConfigurationEditor_ColValue;
        stringArray[2] = "Default value";
        Messages.get();
        stringArray[3] = Messages.ServerConfigurationEditor_ColRestart;
        stringArray[4] = "Description";
        String[] names = stringArray;
        int[] widths = new int[]{200, 150, 150, 80, 500};
        this.viewer = new SortableTableViewer(this.content, names, widths, 0, 67586, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerVariablesLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerVariableComparator());
        this.filter = new ServerVariablesFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ServerConfigurationEditor.this.editVariable();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ServerConfigurationEditor.this.viewer.getSelection();
                ServerConfigurationEditor.this.actionEdit.setEnabled(selection.size() == 1);
                ServerConfigurationEditor.this.actionDelete.setEnabled(selection.size() > 0);
                ServerConfigurationEditor.this.actionDefaultValue.setEnabled(selection.size() > 0);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)"ServerConfigurationEditor");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ServerConfigurationEditor.this.viewer, (IDialogSettings)settings, (String)"ServerConfigurationEditor");
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.netxms.nxmc.serverconfig.viewer");
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(this.actionShowFilter);
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.session = ConsoleSharedData.getSession();
        this.refresh();
    }

    public void refresh() {
        Messages.get();
        new ConsoleJob(Messages.ServerConfigurationEditor_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerConfigurationEditor_LoadJobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerConfigurationEditor.this.varList = ServerConfigurationEditor.this.session.getServerVariables();
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map<String, ServerVariable> map = (this).ServerConfigurationEditor.this.varList;
                        synchronized (map) {
                            (this).ServerConfigurationEditor.this.viewer.setInput((Object)(this).ServerConfigurationEditor.this.varList.values().toArray());
                        }
                    }
                });
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.serverconfig.context.ServerConfigurationEditor");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ServerConfigurationEditor.this.refresh();
            }
        };
        Messages.get();
        this.actionAdd = new Action(Messages.ServerConfigurationEditor_ActionCreate, SharedIcons.ADD_OBJECT){

            public void run() {
                ServerConfigurationEditor.this.addVariable();
            }
        };
        this.actionAdd.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.add_config_variable");
        handlerService.activateHandler(this.actionAdd.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionAdd));
        Messages.get();
        this.actionEdit = new Action(Messages.ServerConfigurationEditor_ActionEdit, SharedIcons.EDIT){

            public void run() {
                ServerConfigurationEditor.this.editVariable();
            }
        };
        this.actionEdit.setEnabled(false);
        Messages.get();
        this.actionDelete = new Action(Messages.ServerConfigurationEditor_ActionDelete, SharedIcons.DELETE_OBJECT){

            public void run() {
                ServerConfigurationEditor.this.deleteVariables();
            }
        };
        this.actionDelete.setEnabled(false);
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                ServerConfigurationEditor.this.enableFilter(!ServerConfigurationEditor.this.initShowFilter);
                ServerConfigurationEditor.this.actionShowFilter.setChecked(ServerConfigurationEditor.this.initShowFilter);
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.show_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        this.actionDefaultValue = new Action("Set default value"){

            public void run() {
                ServerConfigurationEditor.this.setDefaultValue();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("ServerConfigurationEditor.showFilter", this.initShowFilter);
        super.dispose();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServerConfigurationEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionAdd);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IAction)this.actionDefaultValue);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionExportToCsv);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void addVariable() {
        final VariableEditDialog dlg = new VariableEditDialog(this.getSite().getShell(), new ServerVariable(null, "", false, ServerVariableDataType.STRING, "", ""));
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ServerConfigurationEditor_CreateJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ServerConfigurationEditor_CreateJobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerConfigurationEditor.this.session.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ServerConfigurationEditor.this.refresh();
                        }
                    });
                }
            }.start();
        }
    }

    private void editVariable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        ServerVariable var = (ServerVariable)selection.getFirstElement();
        final VariableEditDialog dlg = new VariableEditDialog(this.getSite().getShell(), var);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ServerConfigurationEditor_ModifyJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ServerConfigurationEditor_ModifyJobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerConfigurationEditor.this.session.setServerVariable(dlg.getVarName(), dlg.getVarValue());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ServerConfigurationEditor.this.refresh();
                        }
                    });
                }
            }.start();
        }
    }

    private void deleteVariables() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ServerConfigurationEditor_DeleteConfirmation, (String)Messages.ServerConfigurationEditor_DeleteConfirmationText)) {
            return;
        }
        final ArrayList<String> names = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof ServerVariable)) continue;
            names.add(((ServerVariable)o).getName());
        }
        Messages.get();
        new ConsoleJob(Messages.ServerConfigurationEditor_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (String n : names) {
                    ServerConfigurationEditor.this.session.deleteServerVariable(n);
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerConfigurationEditor.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerConfigurationEditor_DeleteJobError;
            }
        }.start();
    }

    private void setDefaultValue() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        final List list = selection.toList();
        new ConsoleJob("Set default server config values", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ServerConfigurationEditor.this.session.setDefaultServerValues(list);
                ServerConfigurationEditor.this.varList = ServerConfigurationEditor.this.session.getServerVariables();
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map<String, ServerVariable> map = (this).ServerConfigurationEditor.this.varList;
                        synchronized (map) {
                            (this).ServerConfigurationEditor.this.viewer.setInput((Object)(this).ServerConfigurationEditor.this.varList.values().toArray());
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error setting default server config values";
            }
        }.start();
    }
}

