/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actionmanager.dialogs;

import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.client.ServerAction;
import org.netxms.client.constants.ServerActionType;
import org.netxms.ui.eclipse.actionmanager.Messages;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditActionDlg
extends Dialog {
    private ServerAction action;
    private boolean createNew;
    private Text name;
    private LabeledText recipient;
    private LabeledText subject;
    private LabeledText data;
    private Combo channelName;
    private Button typeLocalExec;
    private Button typeRemoteExec;
    private Button typeRemoteSshExec;
    private Button typeExecScript;
    private Button typeNotification;
    private Button typeForward;
    private Button markDisabled;
    private List<NotificationChannel> ncList = null;

    public EditActionDlg(Shell parentShell, ServerAction action, boolean createNew) {
        super(parentShell);
        this.action = action;
        this.createNew = createNew;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        if (this.createNew) {
            Messages.get();
            string = Messages.EditActionDlg_CreateAction;
        } else {
            Messages.get();
            string = Messages.EditActionDlg_EditAction;
        }
        newShell.setText(string);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.name = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)Messages.EditActionDlg_Name, (String)this.action.getName(), (Object)"WidgetHelper::default_layout_data");
        Group typeGroup = new Group(dialogArea, 0);
        Messages.get();
        typeGroup.setText(Messages.EditActionDlg_Type);
        typeGroup.setLayout((Layout)new RowLayout(512));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        typeGroup.setLayoutData((Object)gd);
        this.typeLocalExec = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeLocalExec.setText(Messages.EditActionDlg_ExecCommandOnServer);
        this.typeLocalExec.setSelection(this.action.getType() == ServerActionType.LOCAL_COMMAND);
        this.typeLocalExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeRemoteExec = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeRemoteExec.setText(Messages.EditActionDlg_ExecCommandOnNode);
        this.typeRemoteExec.setSelection(this.action.getType() == ServerActionType.AGENT_COMMAND);
        this.typeRemoteExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeRemoteSshExec = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeRemoteSshExec.setText(Messages.EditActionDlg_ExecSshCommandOnNode);
        this.typeRemoteSshExec.setSelection(this.action.getType() == ServerActionType.SSH_COMMAND);
        this.typeRemoteSshExec.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeExecScript = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeExecScript.setText(Messages.EditActionDlg_ExecuteScript);
        this.typeExecScript.setSelection(this.action.getType() == ServerActionType.NXSL_SCRIPT);
        this.typeExecScript.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeNotification = new Button((Composite)typeGroup, 16);
        this.typeNotification.setText("Send notification");
        this.typeNotification.setSelection(this.action.getType() == ServerActionType.NOTIFICATION);
        this.typeNotification.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        this.typeForward = new Button((Composite)typeGroup, 16);
        Messages.get();
        this.typeForward.setText(Messages.EditActionDlg_ForwardEvent);
        this.typeForward.setSelection(this.action.getType() == ServerActionType.FORWARD_EVENT);
        this.typeForward.addSelectionListener((SelectionListener)new TypeButtonSelectionListener());
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.EditActionDlg_Options);
        optionsGroup.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        this.markDisabled = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.markDisabled.setText(Messages.EditActionDlg_ActionDisabled);
        this.markDisabled.setSelection(this.action.isDisabled());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.channelName = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Channel name", (Object)gd);
        this.channelName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditActionDlg.this.recipient.setEnabled(EditActionDlg.this.ncList.get((int)EditActionDlg.this.channelName.getSelectionIndex()).getConfigurationTemplate().needRecipient);
                EditActionDlg.this.subject.setEnabled(EditActionDlg.this.ncList.get((int)EditActionDlg.this.channelName.getSelectionIndex()).getConfigurationTemplate().needSubject);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.recipient = new LabeledText(dialogArea, 0);
        this.recipient.setLabel(this.getRcptLabel(this.action.getType()));
        this.recipient.setText(this.action.getRecipientAddress());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.recipient.setLayoutData((Object)gd);
        this.subject = new LabeledText(dialogArea, 0);
        Messages.get();
        this.subject.setLabel(Messages.EditActionDlg_MailSubject);
        this.subject.setText(this.action.getEmailSubject());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.subject.setLayoutData((Object)gd);
        this.data = new LabeledText(dialogArea, 0);
        this.data.setLabel(this.getDataLabel(this.action.getType()));
        this.data.setText(this.action.getData());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.data.setLayoutData((Object)gd);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get list of notification channels", null, "org.netxms.ui.eclipse.actionmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                EditActionDlg.this.ncList = session.getNotificationChannels();
                EditActionDlg.this.ncList.sort(new Comparator<NotificationChannel>(){

                    @Override
                    public int compare(NotificationChannel o1, NotificationChannel o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        EditActionDlg.this.onTypeChange();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of notification channels";
            }
        }.start();
        return dialogArea;
    }

    private String getRcptLabel(ServerActionType type) {
        switch (type) {
            case AGENT_COMMAND: 
            case SSH_COMMAND: {
                Messages.get();
                return Messages.EditActionDlg_RemoteHost;
            }
            case FORWARD_EVENT: {
                Messages.get();
                return Messages.EditActionDlg_RemoteServer;
            }
            case NXSL_SCRIPT: {
                Messages.get();
                return Messages.EditActionDlg_ScriptName;
            }
        }
        Messages.get();
        return Messages.EditActionDlg_Recipient;
    }

    private String getDataLabel(ServerActionType type) {
        switch (type) {
            case LOCAL_COMMAND: {
                Messages.get();
                return Messages.EditActionDlg_Command;
            }
            case AGENT_COMMAND: 
            case SSH_COMMAND: {
                Messages.get();
                return Messages.EditActionDlg_Action;
            }
        }
        Messages.get();
        return Messages.EditActionDlg_MessageText;
    }

    protected void okPressed() {
        if (this.typeLocalExec.getSelection()) {
            this.action.setType(ServerActionType.LOCAL_COMMAND);
        } else if (this.typeRemoteExec.getSelection()) {
            this.action.setType(ServerActionType.AGENT_COMMAND);
        } else if (this.typeRemoteSshExec.getSelection()) {
            this.action.setType(ServerActionType.SSH_COMMAND);
        } else if (this.typeExecScript.getSelection()) {
            this.action.setType(ServerActionType.NXSL_SCRIPT);
        } else if (this.typeNotification.getSelection()) {
            this.action.setType(ServerActionType.NOTIFICATION);
        } else if (this.typeForward.getSelection()) {
            this.action.setType(ServerActionType.FORWARD_EVENT);
        }
        this.action.setName(this.name.getText());
        this.action.setRecipientAddress(this.recipient.getText());
        this.action.setEmailSubject(this.subject.getText());
        this.action.setData(this.data.getText());
        this.action.setDisabled(this.markDisabled.getSelection());
        if (this.typeNotification.getSelection()) {
            this.action.setChannelName(this.ncList.get(this.channelName.getSelectionIndex()).getName());
        } else {
            this.action.setChannelName("");
        }
        super.okPressed();
    }

    private void updateChannelList() {
        this.channelName.removeAll();
        boolean needRecipient = false;
        boolean needSubject = false;
        int i = 0;
        while (i < this.ncList.size()) {
            NotificationChannel nc = this.ncList.get(i);
            this.channelName.add(nc.getName());
            if (nc.getName().equals(this.action.getChannelName())) {
                this.channelName.select(i);
                needRecipient = nc.getConfigurationTemplate().needRecipient;
                needSubject = nc.getConfigurationTemplate().needSubject;
            }
            ++i;
        }
        this.recipient.setEnabled(needRecipient);
        this.subject.setEnabled(needSubject);
    }

    private void onTypeChange() {
        ServerActionType type = null;
        if (this.typeLocalExec.getSelection()) {
            type = ServerActionType.LOCAL_COMMAND;
        } else if (this.typeRemoteExec.getSelection()) {
            type = ServerActionType.AGENT_COMMAND;
        } else if (this.typeRemoteSshExec.getSelection()) {
            type = ServerActionType.SSH_COMMAND;
        } else if (this.typeExecScript.getSelection()) {
            type = ServerActionType.NXSL_SCRIPT;
        } else if (this.typeNotification.getSelection()) {
            type = ServerActionType.NOTIFICATION;
        } else if (this.typeForward.getSelection()) {
            type = ServerActionType.FORWARD_EVENT;
        }
        if (type == null) {
            return;
        }
        switch (type) {
            case LOCAL_COMMAND: {
                this.channelName.setEnabled(false);
                this.recipient.setEnabled(false);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case AGENT_COMMAND: 
            case SSH_COMMAND: {
                this.channelName.setEnabled(false);
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(true);
                break;
            }
            case FORWARD_EVENT: 
            case NXSL_SCRIPT: {
                this.channelName.setEnabled(false);
                this.recipient.setEnabled(true);
                this.subject.setEnabled(false);
                this.data.setEnabled(false);
                break;
            }
            case NOTIFICATION: {
                this.channelName.setEnabled(true);
                this.updateChannelList();
                this.data.setEnabled(true);
            }
        }
        this.recipient.setLabel(this.getRcptLabel(type));
        this.data.setLabel(this.getDataLabel(type));
    }

    class TypeButtonSelectionListener
    implements SelectionListener {
        TypeButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            EditActionDlg.this.onTypeChange();
        }
    }
}

