/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.RackPassiveElementEditDialog;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.RackPassiveElementComparator;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.RackPassiveElementLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RackPassiveElements
extends PropertyPage {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_POSITION = 2;
    public static final int COLUMN_ORIENTATION = 3;
    private Rack rack = null;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private List<PassiveRackElement> passiveElements;
    private boolean isModified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.rack = (Rack)this.getElement().getAdapter(Rack.class);
        if (this.rack == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{"Name", "Type", "Position", "Orientation"};
        int[] columnWidths = new int[]{150, 100, 70, 30};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RackPassiveElementLabelProvider());
        this.viewer.setComparator((ViewerComparator)new RackPassiveElementComparator());
        this.passiveElements = new ArrayList<PassiveRackElement>();
        for (PassiveRackElement element : this.rack.getPassiveElements()) {
            this.passiveElements.add(new PassiveRackElement(element));
        }
        this.viewer.setInput(this.passiveElements);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("&Add...");
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RackPassiveElementEditDialog dlg = new RackPassiveElementEditDialog(RackPassiveElements.this.getShell(), null);
                if (dlg.open() == 0) {
                    RackPassiveElements.this.passiveElements.add(dlg.getElement());
                    RackPassiveElements.this.viewer.setInput(RackPassiveElements.this.passiveElements);
                    RackPassiveElements.this.isModified = true;
                }
            }
        });
        this.editButton = new Button(buttons, 8);
        this.editButton.setText("&Edit...");
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RackPassiveElementEditDialog dlg;
                IStructuredSelection selection = (IStructuredSelection)RackPassiveElements.this.viewer.getSelection();
                if (selection.size() == 1 && (dlg = new RackPassiveElementEditDialog(RackPassiveElements.this.getShell(), (PassiveRackElement)selection.getFirstElement())).open() == 0) {
                    RackPassiveElements.this.viewer.setInput(RackPassiveElements.this.passiveElements);
                    RackPassiveElements.this.isModified = true;
                }
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText("&Delete...");
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RackPassiveElements.this.viewer.getSelection();
                RackPassiveElements.this.passiveElements.removeAll(selection.toList());
                RackPassiveElements.this.viewer.setInput(RackPassiveElements.this.passiveElements);
                RackPassiveElements.this.isModified = true;
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RackPassiveElements.this.editButton.notifyListeners(13, new Event());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RackPassiveElements.this.viewer.getSelection();
                RackPassiveElements.this.editButton.setEnabled(selection.size() == 1);
                RackPassiveElements.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.isModified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.rack.getObjectId());
        try {
            md.setPassiveElements(this.passiveElements);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Rack attribute error", (String)("Unable to save rack attribute configuration" + e.getMessage()));
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Update rack attributes", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                RackPassiveElements.this.isModified = false;
            }

            protected String getErrorMessage() {
                return "Rack attribute update error";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).RackPassiveElements.this.isModified = true;
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

