/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.GeoLocation;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.GeoMapConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class GeoMap
extends PropertyPage {
    private GeoMapConfig config;
    private TitleConfigurator title;
    private LabeledText latitude;
    private LabeledText longitude;
    private Spinner zoom;
    private ObjectSelector objectSelector;

    protected Control createContents(Composite parent) {
        this.config = (GeoMapConfig)this.getElement().getAdapter(GeoMapConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.title.setLayoutData(gd);
        this.latitude = new LabeledText(dialogArea, 0);
        Messages.get();
        this.latitude.setLabel(Messages.GeoMap_Latitude);
        this.latitude.setText(GeoLocation.latitudeToString((double)this.config.getLatitude()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.latitude.setLayoutData((Object)gd);
        this.longitude = new LabeledText(dialogArea, 0);
        Messages.get();
        this.longitude.setLabel(Messages.GeoMap_Longitude);
        this.longitude.setText(GeoLocation.longitudeToString((double)this.config.getLongitude()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.longitude.setLayoutData((Object)gd);
        Messages.get();
        this.zoom = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.GeoMap_Zoom, (int)0, (int)18, (Object)"WidgetHelper::default_layout_data");
        this.zoom.setSelection(this.config.getZoom());
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.objectSelector.setLabel(Messages.AlarmViewer_RootObject);
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getRootObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.objectSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        try {
            GeoLocation center = GeoLocation.parseGeoLocation((String)this.latitude.getText(), (String)this.longitude.getText());
            this.config.setLatitude(center.getLatitude());
            this.config.setLongitude(center.getLongitude());
        }
        catch (GeoLocationFormatException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.GeoMap_Error, (String)Messages.GeoMap_ErrorText);
        }
        this.config.setZoom(this.zoom.getSelection());
        this.config.setRootObjectId(this.objectSelector.getObjectId());
        return true;
    }
}

