/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableBarChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableComparisonChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TablePieChartConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableTubeChartConfig;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.perfview.widgets.YAxisRangeEditor;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class TableComparisonChart
extends PropertyPage {
    private TableComparisonChartConfig config;
    private TitleConfigurator title;
    private Spinner refreshRate;
    private Combo legendPosition;
    private Button checkShowLegend;
    private Button checkExtendedLegend;
    private Button checkTranslucent;
    private Button checkTransposed;
    private YAxisRangeEditor yAxisRange;
    private ObjectSelector drillDownObject;

    protected Control createContents(Composite parent) {
        this.config = (TableComparisonChartConfig)this.getElement().getAdapter(TableComparisonChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData(gd);
        Messages.get();
        this.legendPosition = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.TableComparisonChart_LegendPosition, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.legendPosition.add(Messages.TableComparisonChart_Left);
        Messages.get();
        this.legendPosition.add(Messages.TableComparisonChart_Right);
        Messages.get();
        this.legendPosition.add(Messages.TableComparisonChart_Top);
        Messages.get();
        this.legendPosition.add(Messages.TableComparisonChart_Bottom);
        this.legendPosition.select(this.positionIndexFromValue(this.config.getLegendPosition()));
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.TableComparisonChart_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        GridLayout optionsLayout = new GridLayout();
        optionsGroup.setLayout((Layout)optionsLayout);
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowLegend.setText(Messages.TableComparisonChart_ShowLegend);
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkShowLegend.setLayoutData((Object)gd);
        this.checkExtendedLegend = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkExtendedLegend.setText(Messages.AbstractChart_ExtendedLegend);
        this.checkExtendedLegend.setSelection(this.config.isExtendedLegend());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkExtendedLegend.setLayoutData((Object)gd);
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkTranslucent.setText(Messages.TableComparisonChart_Translucent);
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.checkTranslucent.setLayoutData((Object)gd);
        if (this.config instanceof TableBarChartConfig || this.config instanceof TableTubeChartConfig) {
            this.checkTransposed = new Button((Composite)optionsGroup, 32);
            Messages.get();
            this.checkTransposed.setText(Messages.TableComparisonChart_Transposed);
            this.checkTransposed.setSelection(this.config instanceof TableBarChartConfig ? ((TableBarChartConfig)this.config).isTransposed() : ((TableTubeChartConfig)this.config).isTransposed());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.checkTransposed.setLayoutData((Object)gd);
        }
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.TableComparisonChart_RefreshInterval, (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        if (!(this.config instanceof TablePieChartConfig)) {
            this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
            gd = new GridData();
            gd.horizontalSpan = layout.numColumns;
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.yAxisRange.setLayoutData((Object)gd);
            this.yAxisRange.setSelection(this.config.isAutoScale(), this.config.modifyYBase(), this.config.getMinYScaleValue(), this.config.getMaxYScaleValue());
        }
        this.drillDownObject = new ObjectSelector(dialogArea, 0, true);
        this.drillDownObject.setLabel("Drill-down object");
        this.drillDownObject.setObjectClass(AbstractObject.class);
        this.drillDownObject.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
        this.drillDownObject.setObjectId(this.config.getDrillDownObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.drillDownObject.setLayoutData((Object)gd);
        return dialogArea;
    }

    private int positionIndexFromValue(int value) {
        switch (value) {
            case 8: {
                return 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        this.config.setLegendPosition(1 << this.legendPosition.getSelectionIndex());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setExtendedLegend(this.checkExtendedLegend.getSelection());
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        this.config.setDrillDownObjectId(this.drillDownObject.getObjectId());
        if (!(this.config instanceof TablePieChartConfig)) {
            if (!this.yAxisRange.validate(true)) {
                return false;
            }
            this.config.setAutoScale(this.yAxisRange.isAuto());
            this.config.setMinYScaleValue(this.yAxisRange.getMinY());
            this.config.setMaxYScaleValue(this.yAxisRange.getMaxY());
            this.config.setModifyYBase(this.yAxisRange.modifyYBase());
        }
        if (this.config instanceof TableBarChartConfig) {
            ((TableBarChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
        } else if (this.config instanceof TableTubeChartConfig) {
            ((TableTubeChartConfig)this.config).setTransposed(this.checkTransposed.getSelection());
        }
        return true;
    }
}

