/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.agent.config.AgentConfiguration;
import org.netxms.client.agent.config.AgentConfigurationHandle;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.widgets.AgentConfigEditor;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class ServerStoredAgentConfigEditorView
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(ServerStoredAgentConfigEditorView.class);
    public static final String ID = "ServerStoredAgentConfigEditorView";
    private NXCSession session = Registry.getSession();
    private boolean modified = false;
    private boolean reselection = false;
    private Composite editorContent;
    private AgentConfigEditor contentEditor;
    private ScriptEditor filterEditor;
    private LabeledText nameField;
    private TableViewer configList;
    private Action actionSave;
    private Action actionCreate;
    private Action actionDelete;
    private Action actionMoveUp;
    private Action actionMoveDown;
    private List<AgentConfigurationHandle> elements;
    private AgentConfiguration configuration;
    private IStructuredSelection previousSelection;
    private Label configNameLabel;

    public ServerStoredAgentConfigEditorView() {
        super(i18n.tr("Agent Configurations"), ResourceManager.getImageDescriptor((String)"icons/config-views/tunnel_manager.png"), ID, false);
    }

    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm splitter = new SashForm(parent, 256);
        splitter.setSashWidth(3);
        Composite listContainer = new Composite((Composite)splitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        listContainer.setLayout((Layout)layout);
        this.configList = new TableViewer(listContainer, 65540);
        this.configList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.configList.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.configList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.configList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(listContainer, 514).setLayoutData((Object)new GridData(131072, 4, false, true));
        Composite editSection = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        editSection.setLayout((Layout)layout);
        new Label(editSection, 514).setLayoutData((Object)new GridData(131072, 4, false, true));
        this.editorContent = new Composite(editSection, 0);
        this.editorContent.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout();
        this.editorContent.setLayout((Layout)layout);
        this.configNameLabel = new Label(this.editorContent, 1);
        this.configNameLabel.setText(i18n.tr("noname"));
        GridData gridData = new GridData();
        gridData.verticalIndent = 5;
        this.configNameLabel.setLayoutData((Object)gridData);
        splitter.setWeights(new int[]{20, 80});
        this.nameField = new LabeledText(this.editorContent, 2048);
        this.nameField.setLabel(i18n.tr("Name"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.getTextControl().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        Label label = new Label(this.editorContent, 0);
        label.setText(i18n.tr("Filter"));
        gridData = new GridData();
        gridData.verticalIndent = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.filterEditor = new ScriptEditor(this.editorContent, 2048, 768, true, "Variables:\r\n\t$1\tIP address\r\n\t$2\tplatform name\r\n\t$3\tmajor agent version number\r\n\t$4\tminor agent version number\r\n\t$5\trelease number\r\n\r\nReturn value: true if this configuration should be sent to agent");
        this.filterEditor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.filterEditor.setLayoutData((Object)gridData);
        label = new Label(this.editorContent, 0);
        label.setText(i18n.tr("Configuration File"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalIndent = 5;
        label.setLayoutData((Object)gridData);
        this.contentEditor = new AgentConfigEditor(this.editorContent, 2048, 768);
        this.contentEditor.getTextWidget().addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.contentEditor.setLayoutData((Object)gridData);
        this.createActions();
        this.createPopupMenu();
        this.actionSave.setEnabled(false);
        this.refresh();
    }

    private void onSelectionChange(SelectionChangedEvent event) {
        IStructuredSelection selection;
        if (this.reselection) {
            this.reselection = false;
            return;
        }
        if (this.modified) {
            int choice = MessageDialogHelper.openQuestionWithCancel((Shell)this.getWindow().getShell(), (String)i18n.tr("Unsaved Changes"), (String)this.getSaveOnExitPrompt());
            if (choice == 0) {
                this.intermediateSave();
                this.modified = false;
                this.actionSave.setEnabled(false);
                return;
            }
            if (choice == 2) {
                this.reselection = true;
                this.configList.setSelection((ISelection)this.previousSelection);
                return;
            }
        }
        this.previousSelection = selection = (IStructuredSelection)event.getSelection();
        if (selection == null) {
            return;
        }
        AgentConfigurationHandle element = (AgentConfigurationHandle)selection.getFirstElement();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void onTextModify() {
        if (!this.modified) {
            this.modified = true;
            this.actionSave.setEnabled(true);
        }
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.configList.getControl());
        this.configList.getControl().setMenu(menu);
    }

    public void setFocus() {
        this.nameField.setFocus();
    }

    private void createActions() {
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveUp = new /* Unavailable Anonymous Inner Class!! */;
        this.actionMoveDown = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void moveUp() {
        IStructuredSelection selection = (IStructuredSelection)this.configList.getSelection();
        if (selection == null) {
            return;
        }
        AgentConfigurationHandle element1 = (AgentConfigurationHandle)selection.getFirstElement();
        int index = this.elements.indexOf(element1);
        if (index <= 0) {
            return;
        }
        AgentConfigurationHandle element2 = (AgentConfigurationHandle)this.elements.get(index - 1);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void moveDown() {
        IStructuredSelection selection = (IStructuredSelection)this.configList.getSelection();
        if (selection == null) {
            return;
        }
        AgentConfigurationHandle element1 = (AgentConfigurationHandle)selection.getFirstElement();
        int index = this.elements.indexOf(element1);
        if (index >= this.elements.size() - 1) {
            return;
        }
        AgentConfigurationHandle elemen2 = (AgentConfigurationHandle)this.elements.get(index + 1);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteConfig() {
        IStructuredSelection selection = (IStructuredSelection)this.configList.getSelection();
        if (selection == null) {
            return;
        }
        AgentConfigurationHandle element = (AgentConfigurationHandle)selection.getFirstElement();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createNewConfig() {
        this.modified = true;
        this.actionSave.setEnabled(true);
        AgentConfigurationHandle newElement = new AgentConfigurationHandle();
        this.elements.add(newElement);
        this.configList.setInput((Object)this.elements.toArray(new AgentConfigurationHandle[this.elements.size()]));
        this.reselection = true;
        StructuredSelection selection = new StructuredSelection((Object)newElement);
        this.previousSelection = selection;
        this.configList.setSelection((ISelection)selection);
        this.configuration = new AgentConfiguration();
        this.updateContent();
    }

    private void updateContent() {
        this.configNameLabel.setText(this.configuration.getName());
        this.nameField.setText(this.configuration.getName());
        this.contentEditor.setText(this.configuration.getContent());
        this.filterEditor.setText(this.configuration.getFilter());
        this.modified = false;
        this.actionSave.setEnabled(false);
    }

    protected void fillLocalToolbar(ToolBarManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
    }

    public void intermediateSave() {
        if (this.configuration == null) {
            return;
        }
        this.configuration.setContent(this.contentEditor.getText());
        this.configuration.setFilter(this.filterEditor.getText());
        this.configuration.setName(this.nameField.getText());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public String getSaveOnExitPrompt() {
        return i18n.tr("There are unsaved changes to configuration file. Do you want to save them?");
    }

    public void refresh() {
        IStructuredSelection selection = (IStructuredSelection)this.configList.getSelection();
        AgentConfigurationHandle element = selection == null ? null : (AgentConfigurationHandle)selection.getFirstElement();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void save() {
        try {
            this.configuration.setContent(this.contentEditor.getText());
            this.configuration.setFilter(this.filterEditor.getText());
            this.configuration.setName(this.nameField.getText());
            this.session.saveAgentConfig(this.configuration);
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getWindow().getShell(), (String)i18n.tr("Error"), (String)(i18n.tr("Cannot save agent's configuration file: ") + e.getMessage()));
        }
    }
}

