/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.businessservice.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BaseBusinessService;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class DCIAutoBind
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(DCIAutoBind.class);
    private BaseBusinessService businessService;
    private Button checkboxEnableBind;
    private Button checkboxEnableUnbind;
    private Combo thresholdCombo;
    private ScriptEditor filterSource;
    private boolean initialBind;
    private boolean initialUnbind;
    private String initialAutoBindFilter;
    private int initialStatusThreshold;

    public DCIAutoBind(AbstractObject object) {
        super(i18n.tr("DCI Auto Bind"), object);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.businessService = (BaseBusinessService)this.object;
        if (this.businessService == null) {
            return dialogArea;
        }
        this.initialBind = this.businessService.isDciAutoBindEnabled();
        this.initialUnbind = this.businessService.isDciAutoUnbindEnabled();
        this.initialAutoBindFilter = this.businessService.getDciAutoBindFilter();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableBind = new Button(dialogArea, 32);
        this.checkboxEnableBind.setText("Automatically add DCI selected by filter to this business service as check");
        this.checkboxEnableBind.setSelection(this.businessService.isDciAutoBindEnabled());
        this.checkboxEnableBind.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkboxEnableUnbind = new Button(dialogArea, 32);
        this.checkboxEnableUnbind.setText("Automatically remove DCI selected by filter from this business service");
        this.checkboxEnableUnbind.setSelection(this.businessService.isDciAutoUnbindEnabled());
        this.checkboxEnableUnbind.setEnabled(this.businessService.isDciAutoBindEnabled());
        this.thresholdCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Status Threashold"), (Object)new GridData());
        this.thresholdCombo.add(i18n.tr("Default"));
        for (int i = 1; i <= 4; ++i) {
            this.thresholdCombo.add(StatusDisplayInfo.getStatusText((int)i));
        }
        this.thresholdCombo.select(this.businessService.getDciStatusThreshold());
        Label label = new Label(dialogArea, 0);
        label.setText(i18n.tr("Filtering script"));
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, true, "Variables:\r\n\t$node\t\tnode being tested (null if object is not a node).\r\n\t$object\t\tobject being tested.\r\n\t$dci\t\t\tDCI object being tested.\r\n\t$service\tcurrent business service this check belongs to.\r\n\r\nReturn value: true to bind dci to this business service, false to unbind, null to make no changes.");
        this.filterSource.setText(this.businessService.getDciAutoBindFilter());
        this.filterSource.setEnabled(this.businessService.isDciAutoBindEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        boolean apply = this.checkboxEnableBind.getSelection();
        boolean remove = this.checkboxEnableUnbind.getSelection();
        if (apply == this.initialBind && remove == this.initialUnbind && this.initialStatusThreshold == this.thresholdCombo.getSelectionIndex() && this.initialAutoBindFilter.equals(this.filterSource.getText())) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(this.businessService.getObjectId());
        md.setAutoBindFilter2(this.filterSource.getText());
        int flags = this.businessService.getAutoBindFlags();
        flags = apply ? flags | 4 : flags & 0xFFFFFFFB;
        flags = remove ? flags | 8 : flags & 0xFFFFFFF7;
        md.setAutoBindFlags(Integer.valueOf(flags));
        md.setDciStatusThreshold(Integer.valueOf(this.thresholdCombo.getSelectionIndex()));
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    public String getId() {
        return "dciAutoBind";
    }

    public boolean isVisible() {
        return this.object instanceof BaseBusinessService;
    }

    public int getPriority() {
        return 27;
    }
}

