/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.EventSelectionDialog;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class EventSelector
extends AbstractSelector {
    private static final I18n i18n = LocalizationHelper.getI18n(EventSelector.class);
    private long eventCode = 0L;
    private String eventName = null;

    public EventSelector(Composite parent, int style) {
        super(parent, style, 0);
        this.setText(i18n.tr("None"));
    }

    public EventSelector(Composite parent, int style, boolean useHyperlink) {
        super(parent, style, (useHyperlink ? 1 : 0) | 8);
        this.setText(i18n.tr("None"));
    }

    protected void selectionButtonHandler() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            long prevEventCode = this.eventCode;
            EventTemplate[] events = dlg.getSelectedEvents();
            if (events.length > 0) {
                this.eventCode = events[0].getCode();
                this.eventName = events[0].getName();
                this.setText(events[0].getName());
                this.setImage(StatusDisplayInfo.getStatusImage((Severity)events[0].getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(events[0]));
            } else {
                this.eventCode = 0L;
                this.eventName = null;
                this.setText(i18n.tr("None"));
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
            if (prevEventCode != this.eventCode) {
                this.fireModifyListeners();
            }
        }
    }

    protected void clearButtonHandler() {
        if (this.eventCode == 0L) {
            return;
        }
        this.eventCode = 0L;
        this.eventName = null;
        this.setText(i18n.tr("None"));
        this.setImage(null);
        this.getTextControl().setToolTipText(null);
        this.fireModifyListeners();
    }

    public long getEventCode() {
        return this.eventCode;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventCode(long eventCode) {
        if (this.eventCode == eventCode) {
            return;
        }
        this.eventCode = eventCode;
        if (eventCode != 0L) {
            EventTemplate evt = Registry.getSession().findEventTemplateByCode(eventCode);
            if (evt != null) {
                this.eventName = evt.getName();
                this.setText(this.eventName);
                this.setImage(StatusDisplayInfo.getStatusImage((Severity)evt.getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(evt));
            } else {
                this.setText(i18n.tr("Unknown"));
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
        } else {
            this.setText(i18n.tr("None"));
            this.setImage(null);
            this.getTextControl().setToolTipText(null);
        }
        this.fireModifyListeners();
    }

    private String generateToolTipText(EventTemplate evt) {
        StringBuilder sb = new StringBuilder(evt.getName());
        sb.append(" [");
        sb.append(evt.getCode());
        sb.append(i18n.tr("Severity"));
        sb.append(StatusDisplayInfo.getStatusText((Severity)evt.getSeverity()));
        sb.append("\n\n");
        sb.append(evt.getMessage());
        sb.append("\n\n");
        sb.append(evt.getDescription().replace("\r", ""));
        return sb.toString();
    }

    protected String getSelectionButtonToolTip() {
        return i18n.tr("Select event");
    }
}

