/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.widgets;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.jobs.Job;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.widgets.BaseFileViewer;
import org.netxms.nxmc.modules.filemanager.widgets.DynamicFileViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class DynamicFileViewer
extends BaseFileViewer {
    private static final I18n i18n = LocalizationHelper.getI18n(DynamicFileViewer.class);
    private static Logger logger = LoggerFactory.getLogger(DynamicFileViewer.class);
    protected Job monitoringJob = null;
    protected Job restartJob = null;
    protected String fileId = null;
    protected long nodeId = 0L;
    protected String remoteFileName;
    protected NXCSession session = Registry.getSession();
    protected View view;

    public DynamicFileViewer(Composite parent, int style, View view) {
        super(parent, style, view);
        this.setScrollOnAppend(!this.scrollLock);
        1 sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener((SessionListener)sessionListener);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.view = view;
    }

    public void startTracking(long nodeId, String fileId, String remoteFileName) {
        if (this.restartJob != null) {
            this.restartJob.cancel();
        }
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
        }
        this.view.clearMessages();
        this.fileId = fileId;
        this.nodeId = nodeId;
        this.remoteFileName = remoteFileName;
        this.setTextTopIndex();
        this.monitoringJob = new /* Unavailable Anonymous Inner Class!! */;
        this.monitoringJob.setUser(false);
        this.monitoringJob.setSystem(true);
        this.monitoringJob.start();
    }

    public void stopTracking() {
        if (this.restartJob != null) {
            this.restartJob.cancel();
            this.restartJob = null;
        }
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
            this.monitoringJob = null;
            this.fileId = null;
            this.nodeId = 0L;
        }
    }

    private void restartTracking() {
        if (this.monitoringJob != null) {
            this.monitoringJob.cancel();
            this.monitoringJob = null;
        }
        if (this.restartJob != null) {
            this.restartJob.cancel();
        }
        this.text.append("\n\n----------------------------------------------------------------------\n" + i18n.tr("Connection with the agent has been lost. Attempting to reconnect...") + "\n----------------------------------------------------------------------\n");
        this.view.addMessage(3, i18n.tr("Connection with the agent has been lost. Attempting to reconnect..."));
        this.restartJob = new /* Unavailable Anonymous Inner Class!! */;
        this.restartJob.setUser(false);
        this.restartJob.setSystem(true);
        this.restartJob.start();
    }
}

