/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class LocalFileSelector
extends AbstractSelector {
    private static final I18n i18n = LocalizationHelper.getI18n(LocalFileSelector.class);
    private List<File> fileList = new ArrayList();
    private String[] filterExtensions = new String[]{"*"};
    private String[] filterNames = new String[]{i18n.tr("All files")};
    private int selectorType;

    public LocalFileSelector(Composite parent, int style, boolean useHyperlink, int selectorType) {
        super(parent, style, 4 | (useHyperlink ? 1 : 0));
        this.selectorType = selectorType;
        this.setText(i18n.tr("<none>"));
    }

    protected void selectionButtonHandler() {
        FileDialog fd = new FileDialog(this.getShell(), this.selectorType);
        fd.setText(i18n.tr("Select File"));
        WidgetHelper.setFileDialogFilterExtensions((FileDialog)fd, (String[])this.filterExtensions);
        WidgetHelper.setFileDialogFilterNames((FileDialog)fd, (String[])this.filterNames);
        fd.open();
        this.fileList.clear();
        WidgetHelper.getFileDialogFileList((FileDialog)fd, (List)this.fileList);
        this.updateFileList();
    }

    protected String getSelectionButtonToolTip() {
        return i18n.tr("Select file");
    }

    public File getFile() {
        if (this.fileList.size() > 0) {
            return (File)this.fileList.get(0);
        }
        return null;
    }

    public List<File> getFileList() {
        return this.fileList;
    }

    public void setFile(File file) {
        this.fileList.clear();
        this.fileList.add(file);
        this.updateFileList();
    }

    private void updateFileList() {
        StringBuilder fileListString = new StringBuilder();
        for (int i = 0; i < this.fileList.size(); ++i) {
            fileListString.append(((File)this.fileList.get(i)).getName());
            if (i == this.fileList.size() - 1) continue;
            fileListString.append(", ");
        }
        if (this.fileList.size() == 0) {
            fileListString.append(i18n.tr("<none>"));
        }
        this.setText(fileListString.toString());
        this.fireModifyListeners();
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }
}

