/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.dialogs.CreateScriptDialog;
import org.netxms.nxmc.modules.nxsl.views.ScriptEditorView;
import org.netxms.nxmc.modules.nxsl.views.helpers.ScriptComparator;
import org.netxms.nxmc.modules.nxsl.views.helpers.ScriptFilter;
import org.netxms.nxmc.modules.nxsl.views.helpers.ScriptLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ScriptLibraryView
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(ScriptLibraryView.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    private static final String ID = "ScriptLibrary";
    private NXCSession session = Registry.getSession();
    private SortableTableViewer viewer;
    private Action actionNew;
    private Action actionEdit;
    private Action actionRename;
    private Action actionDelete;
    private Action actionCopyName;

    public ScriptLibraryView() {
        super(i18n.tr("Script Library"), ResourceManager.getImageDescriptor((String)"icons/config-views/script_library.png"), ID, true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Name")};
        int[] widths = new int[]{90, 500};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)ID);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScriptLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ScriptComparator());
        ScriptFilter filter = new ScriptFilter();
        this.setFilterClient((StructuredViewer)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
    }

    protected void postContentCreate() {
        this.refresh();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNew);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setEnabled(false);
        this.actionRename = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRename.setEnabled(false);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
        this.actionCopyName = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionRename);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IAction)this.actionCopyName);
    }

    protected void fillLocalToolbar(ToolBarManager manager) {
        super.fillLocalToolbar(manager);
        manager.add((IAction)this.actionNew);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createNewScript() {
        CreateScriptDialog dlg = new CreateScriptDialog(this.getWindow().getShell(), null);
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void editScript() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Script script = (Script)selection.getFirstElement();
        this.openView((View)new ScriptEditorView(script.getId(), script.getName()));
    }

    private void renameScript() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Script script = (Script)selection.getFirstElement();
        CreateScriptDialog dlg = new CreateScriptDialog(this.getWindow().getShell(), script.getName());
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void deleteScript() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Confirm Delete"), (String)i18n.tr("Do you really want to delete selected scripts?"))) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void copyNameToClipboard() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        WidgetHelper.copyToClipboard((String)((Script)selection.getFirstElement()).getName());
    }
}

