/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.widgets.helpers.MenuContributionItem;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.PackageDeployment;
import org.netxms.nxmc.modules.agentmanagement.dialogs.SelectDeployPackage;
import org.netxms.nxmc.modules.agentmanagement.views.AgentConfigEditorView;
import org.netxms.nxmc.modules.agentmanagement.views.PackageDeploymentMonitor;
import org.netxms.nxmc.modules.nxsl.views.ScriptExecutorView;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.ObjectCreateMenuManager;
import org.netxms.nxmc.modules.objects.ObjectMenuFactory;
import org.netxms.nxmc.modules.objects.dialogs.MaintanenceScheduleDialog;
import org.netxms.nxmc.modules.objects.views.ScreenshotView;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectContextMenuManager
extends MenuManager {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectContextMenuManager.class);
    private View view;
    private ISelectionProvider selectionProvider;
    private Action actionManage;
    private Action actionUnmanage;
    private Action actionDeployPackage;
    private Action actionDelete;
    private Action actionEnterMaintenance;
    private Action actionLeaveMaintenance;
    private Action actionScheduleMaintenance;
    private Action actionProperties;
    private Action actionTakeScreenshot;
    private Action actionEditAgentConfig;
    private Action actionExecuteScript;

    public ObjectContextMenuManager(View view, ISelectionProvider selectionProvider) {
        this.view = view;
        this.selectionProvider = selectionProvider;
        this.setRemoveAllWhenShown(true);
        this.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
    }

    private void createActions() {
        this.actionManage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUnmanage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeployPackage = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEnterMaintenance = new /* Unavailable Anonymous Inner Class!! */;
        this.actionLeaveMaintenance = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScheduleMaintenance = new /* Unavailable Anonymous Inner Class!! */;
        this.actionProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.actionTakeScreenshot = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditAgentConfig = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExecuteScript = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillContextMenu() {
        Menu pollsMenu;
        Menu toolsMenu;
        ObjectCreateMenuManager createMenu;
        boolean singleObject;
        boolean bl = singleObject = ((IStructuredSelection)this.selectionProvider.getSelection()).size() == 1;
        if (singleObject && !(createMenu = new ObjectCreateMenuManager(this.getShell(), this.view, this.getObjectFromSelection())).isEmpty()) {
            this.add((IContributionItem)createMenu);
            this.add((IContributionItem)new Separator());
        }
        if (this.isMaintenanceMenuAllowed((IStructuredSelection)this.selectionProvider.getSelection())) {
            MenuManager maintenanceMenu = new MenuManager(this.i18n.tr("&Maintenance"));
            maintenanceMenu.add((IAction)this.actionEnterMaintenance);
            maintenanceMenu.add((IAction)this.actionLeaveMaintenance);
            maintenanceMenu.add((IAction)this.actionScheduleMaintenance);
            this.add((IContributionItem)maintenanceMenu);
        }
        this.add((IAction)this.actionManage);
        this.add((IAction)this.actionUnmanage);
        this.add((IAction)this.actionDelete);
        this.add((IContributionItem)new Separator());
        if (singleObject) {
            AbstractObject object = this.getObjectFromSelection();
            if (object instanceof Node && ((Node)object).hasAgent()) {
                this.add((IAction)this.actionEditAgentConfig);
                this.add((IAction)this.actionDeployPackage);
            }
        } else {
            boolean nodesWithAgent = false;
            for (Object o : ((IStructuredSelection)this.selectionProvider.getSelection()).toList()) {
                if (o instanceof Node) {
                    if (!((Node)o).hasAgent()) continue;
                    nodesWithAgent = true;
                    break;
                }
                for (AbstractObject n : ((AbstractObject)o).getAllChildren(2)) {
                    if (!((Node)n).hasAgent()) continue;
                    nodesWithAgent = true;
                    break;
                }
                if (!nodesWithAgent) continue;
                break;
            }
            if (nodesWithAgent) {
                this.add((IAction)this.actionDeployPackage);
            }
        }
        if (singleObject) {
            AbstractObject object = this.getObjectFromSelection();
            if (object instanceof Node && ((Node)object).hasAgent() && ((Node)object).getPlatformName().startsWith("windows-")) {
                this.add((IContributionItem)new Separator());
                this.add((IAction)this.actionTakeScreenshot);
            }
            this.add((IAction)this.actionExecuteScript);
        }
        if ((toolsMenu = ObjectMenuFactory.createToolsMenu((IStructuredSelection)((IStructuredSelection)this.selectionProvider.getSelection()), (Menu)this.getMenu(), null, (ViewPlacement)new ViewPlacement(this.view))) != null) {
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new MenuContributionItem(this.i18n.tr("&Tools"), toolsMenu));
        }
        if ((pollsMenu = ObjectMenuFactory.createPollMenu((IStructuredSelection)((IStructuredSelection)this.selectionProvider.getSelection()), (Menu)this.getMenu(), null, (ViewPlacement)new ViewPlacement(this.view))) != null) {
            this.add((IContributionItem)new Separator());
            this.add((IContributionItem)new MenuContributionItem(this.i18n.tr("&Poll"), pollsMenu));
        }
        if (singleObject) {
            this.add((IContributionItem)new Separator());
            this.add((IAction)this.actionProperties);
        }
    }

    private boolean isMaintenanceMenuAllowed(IStructuredSelection selection) {
        for (Object o : selection.toList()) {
            if (!(o instanceof AbstractObject)) {
                return false;
            }
            int objectClass = ((AbstractObject)o).getObjectClass();
            if (objectClass != 28 && objectClass != 15 && objectClass != 27 && objectClass != 23 && objectClass != 36 && objectClass != 22 && objectClass != 21 && objectClass != 20 && objectClass != 19 && objectClass != 8 && objectClass != 9 && objectClass != 10) continue;
            return false;
        }
        return true;
    }

    protected Shell getShell() {
        return Registry.getMainWindow().getShell();
    }

    protected AbstractObject getObjectFromSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        if (selection.size() != 1) {
            return null;
        }
        return (AbstractObject)selection.getFirstElement();
    }

    protected long getObjectIdFromSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        if (selection.size() != 1) {
            return 0L;
        }
        return ((AbstractObject)selection.getFirstElement()).getObjectId();
    }

    private void changeObjectManagementState(boolean managed) {
        Object[] objects = ((IStructuredSelection)this.selectionProvider.getSelection()).toArray();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void changeObjectMaintenanceState(boolean enter) {
        String comments;
        if (enter) {
            InputDialog dlg = new InputDialog(null, this.i18n.tr("Enter Maintenance"), this.i18n.tr("Additional comments"), "", null);
            if (dlg.open() != 0) {
                return;
            }
            comments = dlg.getValue().trim();
        } else {
            comments = null;
        }
        Object[] objects = ((IStructuredSelection)this.selectionProvider.getSelection()).toArray();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void scheduleMaintenance() {
        MaintanenceScheduleDialog dialog = new MaintanenceScheduleDialog(this.view.getWindow().getShell());
        if (dialog.open() != 0) {
            return;
        }
        Object[] objects = ((IStructuredSelection)this.selectionProvider.getSelection()).toArray();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deployPackage() {
        SelectDeployPackage dialog = new SelectDeployPackage(this.view.getWindow().getShell());
        if (dialog.open() != 0) {
            return;
        }
        Object[] objectList = ((IStructuredSelection)this.selectionProvider.getSelection()).toArray();
        HashSet<Long> objects = new HashSet<Long>();
        for (Object o : objectList) {
            if (!(o instanceof AbstractObject)) continue;
            objects.add(((AbstractObject)o).getObjectId());
        }
        PackageDeploymentMonitor monitor = new PackageDeploymentMonitor();
        monitor.setPackageId(dialog.getSelectedPackageId());
        monitor.setApplicableObjects(objects);
        PackageDeployment deployment = new PackageDeployment(monitor);
        monitor.setPackageDeploymentListener(deployment);
        Perspective p = this.view.getPerspective();
        if (p != null) {
            p.addMainView((View)monitor, true, false);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)monitor);
            window.open();
        }
        NXCSession session = Registry.getSession();
        16 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void deleteObject() {
        Object[] objects = ((IStructuredSelection)this.selectionProvider.getSelection()).toArray();
        String question = null;
        question = objects.length == 1 ? String.format(this.i18n.tr("Are you sure you want to delete \"%s\"?"), ((AbstractObject)objects[0]).getObjectName()) : String.format(this.i18n.tr("Are you sure you want to delete %d objects?"), objects.length);
        boolean confirmed = MessageDialogHelper.openConfirm((Shell)this.view.getWindow().getShell(), (String)this.i18n.tr("Confirm Delete"), (String)question);
        if (confirmed) {
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void openScreenshotView() {
        AbstractObject object = this.getObjectFromSelection();
        if (!(object instanceof Node)) {
            return;
        }
        ScreenshotView screenshotView = new ScreenshotView((AbstractNode)((Node)object), null, null);
        if (this.view.getPerspective() != null) {
            this.view.getPerspective().addMainView((View)screenshotView, true, false);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)screenshotView);
            window.open();
        }
    }

    private void openAgentConfigEditor() {
        AbstractObject object = this.getObjectFromSelection();
        if (!(object instanceof Node)) {
            return;
        }
        AgentConfigEditorView editor = new AgentConfigEditorView((Node)object);
        if (this.view.getPerspective() != null) {
            this.view.getPerspective().addMainView((View)editor, true, false);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)editor);
            window.open();
        }
    }

    private void executeScript() {
        AbstractObject object = this.getObjectFromSelection();
        ScriptExecutorView executor = new ScriptExecutorView(object.getObjectId());
        if (this.view.getPerspective() != null) {
            this.view.getPerspective().addMainView((View)executor, true, false);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)executor);
            window.open();
        }
    }
}

