/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.InputField;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.InputFieldType;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.ObjectToolHandler;
import org.netxms.nxmc.modules.objects.ObjectToolsCache;
import org.netxms.nxmc.modules.objects.dialogs.ObjectToolInputDialog;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ObjectToolExecutor {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);
    private static final Logger logger = LoggerFactory.getLogger(ObjectToolExecutor.class);

    private ObjectToolExecutor() {
    }

    public static boolean isToolAllowed(ObjectTool tool, Set<ObjectContext> nodes) {
        if (tool.getToolType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (handler != null) {
            for (ObjectContext n : nodes) {
                if (!handler.canExecuteOnNode(n.object, tool)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isToolApplicable(ObjectTool tool, Set<ObjectContext> nodes) {
        for (ObjectContext n : nodes) {
            if (!tool.isApplicableForNode(n.object)) continue;
            return true;
        }
        return false;
    }

    public static void execute(Set<ObjectContext> allNodes, ObjectTool tool, ViewPlacement viewPlacement) {
        Map inputValues;
        HashSet<ObjectContext> nodes = new HashSet<ObjectContext>();
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (tool.getToolType() != 0 || handler != null) {
            for (ObjectContext n : allNodes) {
                if (tool.getToolType() == 0 && !handler.canExecuteOnNode(n.object, tool) || !tool.isApplicableForNode(n.object)) continue;
                nodes.add(n);
            }
        } else {
            return;
        }
        ArrayList<String> maskedFields = new ArrayList<String>();
        InputField[] fields = tool.getInputFields();
        if (fields.length > 0) {
            Arrays.sort(fields, new /* Unavailable Anonymous Inner Class!! */);
            inputValues = ObjectToolExecutor.readInputFields((String)tool.getDisplayName(), (InputField[])fields);
            if (inputValues == null) {
                return;
            }
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getType() != InputFieldType.PASSWORD) continue;
                maskedFields.add(fields[i].getName());
            }
        } else {
            inputValues = new HashMap(0);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private static Map<String, String> readInputFields(String title, InputField[] fields) {
        ObjectToolInputDialog dlg = new ObjectToolInputDialog(Registry.getMainWindow().getShell(), title, fields);
        if (dlg.open() != 0) {
            return null;
        }
        return dlg.getValues();
    }

    private static void executeOnNode(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, String expandedToolData, ViewPlacement viewPlacement) {
        switch (tool.getToolType()) {
            case 1: {
                ObjectToolExecutor.executeAgentAction((ObjectContext)node, (ObjectTool)tool, inputValues, maskedFields, (ViewPlacement)viewPlacement);
                break;
            }
            case 7: {
                ObjectToolExecutor.executeFileDownload((ObjectContext)node, (ObjectTool)tool, inputValues);
                break;
            }
            case 0: {
                ObjectToolExecutor.executeInternalTool((ObjectContext)node, (ObjectTool)tool);
                break;
            }
            case 5: {
                ObjectToolExecutor.executeLocalCommand((ObjectContext)node, (ObjectTool)tool, inputValues, (String)expandedToolData);
                break;
            }
            case 6: {
                ObjectToolExecutor.executeServerCommand((ObjectContext)node, (ObjectTool)tool, inputValues, maskedFields);
                break;
            }
            case 8: {
                ObjectToolExecutor.executeServerScript((ObjectContext)node, (ObjectTool)tool, inputValues);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                ObjectToolExecutor.executeTableTool((ObjectContext)node, (ObjectTool)tool);
                break;
            }
            case 4: {
                ObjectToolExecutor.openURL((ObjectContext)node, (ObjectTool)tool, inputValues, (String)expandedToolData);
            }
        }
    }

    private static void executeOnMultipleNodes(Set<ObjectContext> nodes, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, List<String> expandedToolData, ViewPlacement viewPlacement) {
    }

    private static void executeTableTool(ObjectContext node, ObjectTool tool) {
    }

    private static void executeAgentAction(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private static void executeServerCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields) {
        NXCSession session = Registry.getSession();
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private static void executeServerScript(ObjectContext node, ObjectTool tool, Map<String, String> inputValues) {
        NXCSession session = Registry.getSession();
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private static void executeLocalCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, String command) {
        if ((tool.getFlags() & 2) == 0) {
            try {
                if (SystemUtils.IS_OS_WINDOWS) {
                    command = "CMD.EXE /C START \"NetXMS\" " + (String)command;
                    Runtime.getRuntime().exec((String)command);
                } else {
                    Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
                }
            }
            catch (IOException e) {
                logger.error("Exception while executing local command", (Throwable)e);
            }
        }
    }

    private static void executeFileDownload(ObjectContext node, ObjectTool tool, Map<String, String> inputValues) {
    }

    private static void executeInternalTool(ObjectContext node, ObjectTool tool) {
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (handler != null) {
            handler.execute(node.object, tool);
        } else {
            MessageDialogHelper.openError((Shell)Registry.getMainWindow().getShell(), (String)i18n.tr("Error"), (String)i18n.tr("Cannot execute object tool: handler not defined"));
        }
    }

    private static void openURL(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, String url) {
    }
}

