/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class MaintenanceJournalEditDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(MaintenanceJournalEditDialog.class);
    private String objectName;
    private String description;
    private LabeledText descriptionText;

    public MaintenanceJournalEditDialog(Shell parentShell, String objectName, String description) {
        super(parentShell);
        this.objectName = objectName;
        this.description = description != null ? description : "";
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.description.isEmpty() ? this.i18n.tr("Create Maintenance Journal Entry") : this.i18n.tr("Edit Maintenance Journal Entry"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 16);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 700;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        LabeledText objectText = new LabeledText(dialogArea, 0);
        objectText.setLabel(this.i18n.tr("Object"));
        objectText.setText(this.objectName);
        objectText.setLayoutData((Object)gd);
        objectText.getTextControl().setEditable(false);
        gd = new GridData();
        gd.heightHint = 400;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.descriptionText = new LabeledText(dialogArea, 0, 2626);
        this.descriptionText.setLabel(this.i18n.tr("Description"));
        this.descriptionText.setText(this.description);
        this.descriptionText.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        if (this.description.equals(this.descriptionText.getText())) {
            super.cancelPressed();
        } else {
            this.description = this.descriptionText.getText();
            super.okPressed();
        }
    }

    public String getDescription() {
        return this.description;
    }
}

