/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectUrl;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectUrlEditDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.helpers.UrlListLabelProvider;
import org.xnap.commons.i18n.I18n;

public class ExternalResources
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(ExternalResources.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    private SortableTableViewer viewer;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private List<ObjectUrl> urls = null;
    private boolean modified = false;

    public ExternalResources(AbstractObject object) {
        super(i18n.tr("External Resources"), object);
    }

    public String getId() {
        return "externalResources";
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{i18n.tr("URL"), i18n.tr("Description")};
        int[] columnWidths = new int[]{300, 300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new UrlListLabelProvider());
        this.urls = new ArrayList(this.object.getUrls());
        this.viewer.setInput((Object)this.urls);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttonsLeft = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gridData);
        this.moveUpButton = new Button(buttonsLeft, 8);
        this.moveUpButton.setText(i18n.tr("&Up"));
        RowData rd = new RowData();
        rd.width = 90;
        this.moveUpButton.setLayoutData((Object)rd);
        this.moveUpButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.moveDownButton = new Button(buttonsLeft, 8);
        this.moveDownButton.setText(i18n.tr("&Down"));
        rd = new RowData();
        rd.width = 90;
        this.moveDownButton.setLayoutData((Object)rd);
        this.moveDownButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonsRight = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gridData);
        this.addButton = new Button(buttonsRight, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(buttonsRight, 8);
        this.editButton.setText(i18n.tr("&Modify..."));
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttonsRight, 8);
        this.deleteButton.setText(i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addUrl() {
        ObjectUrlEditDialog dlg = new ObjectUrlEditDialog(this.getShell(), null, null);
        if (dlg.open() != 0) {
            return;
        }
        this.urls.add(new ObjectUrl(this.urls.size(), dlg.getUrl(), dlg.getDescription()));
        this.viewer.refresh();
        this.modified = true;
    }

    private void editUrl() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectUrl url = (ObjectUrl)selection.getFirstElement();
        ObjectUrlEditDialog dlg = new ObjectUrlEditDialog(this.getShell(), url.getUrl(), url.getDescription());
        if (dlg.open() != 0) {
            return;
        }
        int index = this.urls.indexOf(url);
        this.urls.set(index, new ObjectUrl(url.getId(), dlg.getUrl(), dlg.getDescription()));
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection(this.urls.get(index)));
        this.modified = true;
    }

    private void deleteUrl() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        for (Object o : selection.toList()) {
            this.urls.remove(o);
        }
        for (int i = 0; i < this.urls.size(); ++i) {
            ObjectUrl u = (ObjectUrl)this.urls.get(i);
            this.urls.set(i, new ObjectUrl(i, u.getUrl(), u.getDescription()));
        }
        this.viewer.refresh();
        this.modified = true;
    }

    private void moveSelection(boolean up) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectUrl url = (ObjectUrl)selection.getFirstElement();
        int index = this.urls.indexOf(url);
        if (index == 0 && up || index == this.urls.size() - 1 && !up) {
            return;
        }
        int swapIndex = up ? index - 1 : index + 1;
        ObjectUrl swapUrl = (ObjectUrl)this.urls.get(swapIndex);
        this.urls.set(index, new ObjectUrl(index, swapUrl.getUrl(), swapUrl.getDescription()));
        this.urls.set(swapIndex, new ObjectUrl(index, url.getUrl(), url.getDescription()));
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection(this.urls.get(swapIndex)));
        this.modified = true;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.modified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setUrls(new ArrayList(this.urls));
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

