/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.ThemeEngine;

public class AccessListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final NXCSession session = Registry.getSession();
    private final Color inheritedElementColor = ThemeEngine.getForegroundColor((String)"List.DisabledItem");

    public Image getColumnImage(Object element, int columnIndex) {
        long userId;
        AbstractUserObject userObject;
        if (columnIndex == 0 && element instanceof AccessListElement && (userObject = this.session.findUserDBObjectById(userId = ((AccessListElement)element).getUserId(), null)) != null) {
            return userObject instanceof User ? SharedIcons.IMG_USER : SharedIcons.IMG_GROUP;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                long userId = ((AccessListElement)element).getUserId();
                AbstractUserObject userObject = this.session.findUserDBObjectById(userId, null);
                return userObject != null ? userObject.getName() : "[" + userId + "]";
            }
            case 1: {
                AccessListElement e = (AccessListElement)element;
                StringBuilder sb = new StringBuilder(16);
                sb.append(e.hasRead() ? (char)'R' : '-');
                sb.append(e.hasModify() ? (char)'M' : '-');
                sb.append(e.hasCreate() ? (char)'C' : '-');
                sb.append(e.hasDelete() ? (char)'D' : '-');
                sb.append(e.hasControl() ? (char)'O' : '-');
                sb.append(e.hasSendEvents() ? (char)'E' : '-');
                sb.append(e.hasReadAlarms() ? (char)'V' : '-');
                sb.append(e.hasAckAlarms() ? (char)'K' : '-');
                sb.append(e.hasTerminateAlarms() ? (char)'T' : '-');
                sb.append(e.hasPushData() ? (char)'P' : '-');
                sb.append(e.hasAccessControl() ? (char)'A' : '-');
                return sb.toString();
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return ((AccessListElement)element).isInherited() ? this.inheritedElementColor : null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

