/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.widgets.EventSelector;
import org.netxms.nxmc.modules.snmp.dialogs.MibSelectionDialog;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SnmpTrapGeneral
extends PropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(SnmpTrapGeneral.class);
    private SnmpTrap trap;
    private Text description;
    private Text oid;
    private EventSelector event;
    private Text eventTag;
    private Button buttonSelect;

    public SnmpTrapGeneral(SnmpTrap trap) {
        super("General");
        this.noDefaultAndApplyButton();
        this.trap = trap;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.description = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)this.i18n.tr("Description"), (String)this.trap.getDescription(), (Object)"WidgetHelper::default_layout_data");
        Composite oidSelection = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        oidSelection.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        oidSelection.setLayoutData((Object)gd);
        this.oid = WidgetHelper.createLabeledText((Composite)oidSelection, (int)2048, (int)300, (String)this.i18n.tr("Trap OID"), (String)(this.trap.getObjectId() != null ? this.trap.getObjectId().toString() : ""), (Object)"WidgetHelper::default_layout_data");
        this.buttonSelect = new Button(oidSelection, 8);
        this.buttonSelect.setText(this.i18n.tr("&Select..."));
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 1024;
        this.buttonSelect.setLayoutData((Object)gd);
        this.buttonSelect.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.event = new EventSelector(dialogArea, 0);
        this.event.setLabel(this.i18n.tr("Event"));
        this.event.setEventCode((long)this.trap.getEventCode());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.event.setLayoutData((Object)gd);
        this.eventTag = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)-1, (String)this.i18n.tr("Event tag"), (String)this.trap.getEventTag(), (Object)"WidgetHelper::default_layout_data");
        return dialogArea;
    }

    private void selectObjectId() {
        SnmpObjectId id;
        try {
            id = SnmpObjectId.parseSnmpObjectId((String)this.oid.getText());
        }
        catch (SnmpObjectIdFormatException e) {
            id = null;
        }
        MibSelectionDialog dlg = new MibSelectionDialog(this.getShell(), id, 0L);
        if (dlg.open() == 0) {
            this.oid.setText(dlg.getSelectedObjectId().toString());
            this.oid.setFocus();
        }
    }

    protected boolean applyChanges(boolean isApply) {
        try {
            this.trap.setObjectId(SnmpObjectId.parseSnmpObjectId((String)this.oid.getText()));
        }
        catch (SnmpObjectIdFormatException e) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("SNMP OID you have entered is invalid. Please enter correct SNMP OID."));
            return false;
        }
        this.trap.setDescription(this.description.getText());
        this.trap.setEventCode((int)this.event.getEventCode());
        this.trap.setEventTag(this.eventTag.getText());
        return true;
    }
}

