/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.client.snmp.SnmpTrapParameterMapping;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.snmp.dialogs.ParameterMappingEditDialog;
import org.netxms.nxmc.modules.snmp.propertypages.SnmpTrapParameters;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SnmpTrapParameters
extends PropertyPage {
    private static final String PARAMLIST_TABLE_SETTINGS = "TrapConfigurationDialog.ParamList";
    private I18n i18n = LocalizationHelper.getI18n(SnmpTrapParameters.class);
    private SnmpTrap trap;
    private List<SnmpTrapParameterMapping> pmap;
    private TableViewer paramList;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonDelete;
    private Button buttonUp;
    private Button buttonDown;

    public SnmpTrapParameters(SnmpTrap trap) {
        super("Parameters");
        this.noDefaultAndApplyButton();
        this.trap = trap;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.paramList = new TableViewer(dialogArea, 67584);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 300;
        this.paramList.getTable().setLayoutData((Object)gd);
        this.setupParameterList();
        Composite buttonArea = new Composite(dialogArea, 0);
        RowLayout btnLayout = new RowLayout();
        btnLayout.type = 512;
        btnLayout.marginBottom = 0;
        btnLayout.marginLeft = 0;
        btnLayout.marginRight = 0;
        btnLayout.marginTop = 0;
        btnLayout.fill = true;
        btnLayout.spacing = 4;
        buttonArea.setLayout((Layout)btnLayout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttonArea.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttonArea, 8);
        this.buttonAdd.setText(this.i18n.tr("&Add..."));
        this.buttonAdd.setLayoutData((Object)new RowData(90, -1));
        this.buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonEdit = new Button(buttonArea, 8);
        this.buttonEdit.setText(this.i18n.tr("&Edit..."));
        this.buttonEdit.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonEdit.setEnabled(false);
        this.buttonDelete = new Button(buttonArea, 8);
        this.buttonDelete.setText(this.i18n.tr("&Delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonDelete.setEnabled(false);
        this.buttonUp = new Button(buttonArea, 8);
        this.buttonUp.setText(this.i18n.tr("Move &up"));
        this.buttonDown = new Button(buttonArea, 8);
        this.buttonDown.setText(this.i18n.tr("Move &down"));
        return dialogArea;
    }

    private void addParameter() {
        SnmpTrapParameterMapping pm = new SnmpTrapParameterMapping(new SnmpObjectId());
        ParameterMappingEditDialog dlg = new ParameterMappingEditDialog(this.getShell(), pm);
        if (dlg.open() == 0) {
            this.pmap.add(pm);
            this.paramList.setInput((Object)this.pmap.toArray());
            this.paramList.setSelection((ISelection)new StructuredSelection((Object)pm));
        }
    }

    private void editParameter() {
        IStructuredSelection selection = this.paramList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SnmpTrapParameterMapping pm = (SnmpTrapParameterMapping)selection.getFirstElement();
        ParameterMappingEditDialog dlg = new ParameterMappingEditDialog(this.getShell(), pm);
        if (dlg.open() == 0) {
            this.paramList.update((Object)pm, null);
        }
    }

    private void deleteParameters() {
        IStructuredSelection selection = this.paramList.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.pmap.remove(it.next());
        }
        this.paramList.setInput((Object)this.pmap.toArray());
    }

    private void setupParameterList() {
        Table table = this.paramList.getTable();
        table.setHeaderVisible(true);
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText(this.i18n.tr("Number"));
        tc.setWidth(90);
        tc = new TableColumn(table, 16384);
        tc.setText(this.i18n.tr("Parameter"));
        tc.setWidth(200);
        this.pmap = new ArrayList(this.trap.getParameterMapping());
        this.paramList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.paramList.setLabelProvider((IBaseLabelProvider)new ParameterMappingLabelProvider(this));
        this.paramList.setInput((Object)this.pmap.toArray());
        WidgetHelper.restoreColumnSettings((Table)table, (String)PARAMLIST_TABLE_SETTINGS);
        this.paramList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.paramList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void saveSettings() {
        WidgetHelper.saveColumnSettings((Table)this.paramList.getTable(), (String)PARAMLIST_TABLE_SETTINGS);
    }

    protected boolean applyChanges(boolean isApply) {
        this.trap.getParameterMapping().clear();
        this.trap.getParameterMapping().addAll(this.pmap);
        this.saveSettings();
        return true;
    }

    public boolean performCancel() {
        if (this.isControlCreated()) {
            this.saveSettings();
        }
        return super.performCancel();
    }
}

