/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.xnap.commons.i18n.I18n;

public class NumericTextFieldValidator
implements TextFieldValidator {
    private I18n i18n = LocalizationHelper.getI18n(NumericTextFieldValidator.class);
    private long min;
    private long max;
    private String range;

    public NumericTextFieldValidator(long min, long max) {
        this.min = min;
        this.max = max;
        this.range = Long.toString(min) + this.i18n.tr("..") + Long.toString(max);
    }

    public boolean validate(String text) {
        try {
            long value = Long.parseLong(text);
            return value >= this.min && value <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getErrorMessage(String text, String label) {
        return String.format(this.i18n.tr("Please enter number in range %s in field \"%s\""), this.range, label);
    }
}

