/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.DataFormatter;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.api.GaugeColorMode;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.GenericGauge;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class DialGauge
extends GenericGauge {
    private static final int NEEDLE_PIN_RADIUS = 8;
    private static final int SCALE_OFFSET = 30;
    private static final int SCALE_WIDTH = 10;
    private Font[] scaleFonts = null;
    private Font[] valueFonts = null;

    public DialGauge(Chart parent) {
        super(parent);
    }

    @Override
    protected void createFonts() {
        String fontName = this.chart.getConfiguration().getFontName();
        this.scaleFonts = new Font[16];
        int i = 0;
        while (i < this.scaleFonts.length) {
            this.scaleFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
            ++i;
        }
        this.valueFonts = new Font[16];
        i = 0;
        while (i < this.valueFonts.length) {
            this.valueFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 1);
            ++i;
        }
    }

    @Override
    protected void disposeFonts() {
        int i;
        if (this.scaleFonts != null) {
            i = 0;
            while (i < this.scaleFonts.length) {
                this.scaleFonts[i].dispose();
                ++i;
            }
        }
        if (this.valueFonts != null) {
            i = 0;
            while (i < this.valueFonts.length) {
                this.valueFonts[i].dispose();
                ++i;
            }
        }
    }

    @Override
    protected void renderElement(GC gc, ChartConfiguration configuration, GraphItem dci, DataSeries data, int x, int y, int w, int h) {
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        if (configuration.areLabelsVisible() && !configuration.areLabelsInside()) {
            rect.height -= gc.textExtent((String)"MMM").y + 4;
        }
        if (rect.height > rect.width) {
            rect.y += (rect.height - rect.width) / 2;
            rect.height = rect.width;
        } else {
            rect.x += (rect.width - rect.height) / 2;
            rect.width = rect.height;
        }
        double maxValue = configuration.getMaxYScaleValue();
        double minValue = configuration.getMinYScaleValue();
        double angleValue = (maxValue - minValue) / 270.0;
        int outerRadius = (rect.width + 1) / 2;
        int scaleOuterOffset = rect.width / 2 * 30 / 100;
        int scaleInnerOffset = rect.width / 2 * 40 / 100;
        int cx = rect.x + rect.width / 2 + 1;
        int cy = rect.y + rect.height / 2 + 1;
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.fillArc(rect.x, rect.y, rect.width, rect.height, 0, 360);
        switch (GaugeColorMode.getByValue(configuration.getGaugeColorMode())) {
            case ZONE: {
                int startAngle = 225;
                startAngle = this.drawZone(gc, rect, startAngle, minValue, configuration.getLeftRedZone(), angleValue, RED_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getLeftRedZone(), configuration.getLeftYellowZone(), angleValue, YELLOW_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getLeftYellowZone(), configuration.getRightYellowZone(), angleValue, GREEN_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getRightYellowZone(), configuration.getRightRedZone(), angleValue, YELLOW_ZONE_COLOR);
                startAngle = this.drawZone(gc, rect, startAngle, configuration.getRightRedZone(), maxValue, angleValue, RED_ZONE_COLOR);
                break;
            }
            case CUSTOM: {
                this.drawZone(gc, rect, 225, minValue, maxValue, angleValue, this.chart.getPaletteEntry(0).getRGBObject());
                break;
            }
        }
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.PlotArea"));
        gc.setForeground(this.getColorFromPreferences("Chart.Axis.Y.Color"));
        gc.fillArc(rect.x + scaleInnerOffset, rect.y + scaleInnerOffset, rect.width - scaleInnerOffset * 2, rect.height - scaleInnerOffset * 2, 0, 360);
        gc.setLineWidth(2);
        gc.drawArc(rect.x, rect.y, rect.width, rect.height, 0, 360);
        gc.setLineWidth(1);
        Color scaleColor = this.getColorFromPreferences("Chart.Colors.DialScale");
        Color scaleTextColor = this.getColorFromPreferences("Chart.Colors.DialScaleText");
        gc.setForeground(scaleColor);
        int textOffset = rect.width / 2 * 30 / 200;
        double arcLength = (double)(outerRadius - scaleOuterOffset) * 4.71238898038469;
        int step = arcLength >= 200.0 ? 27 : 54;
        double valueStep = Math.abs((maxValue - minValue) / (double)(arcLength >= 200.0 ? 10 : 20));
        int textWidth = (int)(Math.sqrt((outerRadius - scaleOuterOffset) * (outerRadius - scaleOuterOffset) / 2) * 0.7);
        Font markFont = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.scaleFonts, (String)"900MM", (int)textWidth, (int)(outerRadius - scaleOuterOffset));
        gc.setFont(markFont);
        int i = 225;
        while (i >= -45) {
            if (configuration.isGridVisible()) {
                gc.setForeground(scaleColor);
                Point l1 = this.positionOnArc(cx, cy, outerRadius - scaleOuterOffset, i);
                Point l2 = this.positionOnArc(cx, cy, outerRadius - scaleInnerOffset, i);
                gc.drawLine(l1.x, l1.y, l2.x, l2.y);
            }
            double angle = (double)(225 - i) * angleValue + minValue;
            String value = DataFormatter.roundDecimalValue((double)angle, (double)valueStep, (int)5);
            Point t = this.positionOnArc(cx, cy, outerRadius - textOffset, i);
            Point ext = gc.textExtent(value, 1);
            gc.setForeground(scaleTextColor);
            gc.drawText(value, t.x - ext.x / 2, t.y - ext.y / 2, 1);
            i -= step;
        }
        gc.setForeground(scaleColor);
        gc.drawArc(rect.x + scaleOuterOffset, rect.y + scaleOuterOffset, rect.width - scaleOuterOffset * 2, rect.height - scaleOuterOffset * 2, -45, 270);
        gc.drawArc(rect.x + scaleInnerOffset, rect.y + scaleInnerOffset, rect.width - scaleInnerOffset * 2, rect.height - scaleInnerOffset * 2, -45, 270);
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.DialNeedle"));
        double dciValue = data.getCurrentValue();
        if (dciValue < minValue) {
            dciValue = minValue;
        }
        if (dciValue > maxValue) {
            dciValue = maxValue;
        }
        int angle = (int)(225.0 - (dciValue - minValue) / angleValue);
        Point needleEnd = this.positionOnArc(cx, cy, outerRadius - rect.width / 2 * 5 / 100, angle);
        Point np1 = this.positionOnArc(cx, cy, 4, angle - 90);
        Point np2 = this.positionOnArc(cx, cy, 4, angle + 90);
        gc.fillPolygon(new int[]{np1.x, np1.y, needleEnd.x, needleEnd.y, np2.x, np2.y});
        gc.fillArc(cx - 8, cy - 8, 15, 15, 0, 360);
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.DialNeedlePin"));
        gc.fillArc(cx - 4, cy - 4, 7, 7, 0, 360);
        String value = this.getValueAsDisplayString(dci, data);
        gc.setFont(WidgetHelper.getMatchingSizeFont((Font[])this.valueFonts, (Font)markFont));
        Point ext = gc.textExtent(value, 1);
        gc.setLineWidth(3);
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.DialValueBackground"));
        int boxW = Math.max(outerRadius - scaleInnerOffset - 6, ext.x + 8);
        gc.fillRoundRectangle(cx - boxW / 2, cy + rect.height / 4, boxW, ext.y + 6, 3, 3);
        gc.setForeground(this.getColorFromPreferences("Chart.Colors.DialValueText"));
        gc.drawText(value, cx - ext.x / 2, cy + rect.height / 4 + 3, true);
        if (configuration.areLabelsVisible()) {
            gc.setFont((Font)(configuration.areLabelsInside() ? markFont : null));
            ext = gc.textExtent(dci.getDescription(), 1);
            gc.setForeground(this.getColorFromPreferences("Chart.Colors.Legend"));
            if (configuration.areLabelsInside()) {
                gc.drawText(dci.getDescription(), rect.x + (rect.width - ext.x) / 2, rect.y + scaleInnerOffset / 2 + rect.height / 4, true);
            } else {
                gc.drawText(dci.getDescription(), rect.x + (rect.width - ext.x) / 2, rect.y + rect.height + 4, true);
            }
        }
    }

    private int drawZone(GC gc, Rectangle rect, int startAngle, double minValue, double maxValue, double angleValue, RGB color) {
        if (minValue >= maxValue) {
            return startAngle;
        }
        int angle = (int)((maxValue - minValue) / angleValue);
        if (angle <= 0) {
            return startAngle;
        }
        int offset = rect.width / 2 * 30 / 100;
        gc.setBackground(this.chart.getColorCache().create(color));
        gc.fillArc(rect.x + offset, rect.y + offset, rect.width - offset * 2, rect.height - offset * 2, startAngle, -angle);
        return startAngle - angle;
    }

    private Point positionOnArc(int cx, int cy, int radius, int angle) {
        return new Point((int)((double)radius * Math.cos(Math.toRadians(angle)) + (double)cx), (int)((double)radius * -Math.sin(Math.toRadians(angle)) + (double)cy));
    }

    @Override
    protected Point getMinElementSize() {
        return new Point(40, 40);
    }
}

