/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.ThresholdStateChange;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.internal.ThresholdTreeComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.ThresholdTreeContentProvider;
import org.netxms.ui.eclipse.datacollection.widgets.internal.ThresholdTreeLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.MessageBar;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class ThresholdSummaryWidget
extends CompositeWithMessageBar {
    public static final int COLUMN_NODE = 0;
    public static final int COLUMN_STATUS = 1;
    public static final int COLUMN_PARAMETER = 2;
    public static final int COLUMN_VALUE = 3;
    public static final int COLUMN_CONDITION = 4;
    public static final int COLUMN_TIMESTAMP = 5;
    private AbstractObject object;
    private IViewPart viewPart;
    private SortableTreeViewer viewer;
    private VisibilityValidator visibilityValidator;
    private boolean subscribed = false;
    private boolean refreshScheduled = false;

    public ThresholdSummaryWidget(Composite parent, int style, IViewPart viewPart, VisibilityValidator visibilityValidator) {
        super(parent, style);
        this.viewPart = viewPart;
        this.visibilityValidator = visibilityValidator;
        String[] stringArray = new String[6];
        Messages.get();
        stringArray[0] = Messages.ThresholdSummaryWidget_Node;
        Messages.get();
        stringArray[1] = Messages.ThresholdSummaryWidget_Status;
        Messages.get();
        stringArray[2] = Messages.ThresholdSummaryWidget_Parameter;
        Messages.get();
        stringArray[3] = Messages.ThresholdSummaryWidget_Value;
        Messages.get();
        stringArray[4] = Messages.ThresholdSummaryWidget_Condition;
        Messages.get();
        stringArray[5] = Messages.ThresholdSummaryWidget_Since;
        String[] names = stringArray;
        int[] widths = new int[]{200, 100, 250, 100, 100, 140};
        this.viewer = new SortableTreeViewer(this.getContent(), names, widths, 0, 128, 65536);
        this.viewer.setContentProvider((IContentProvider)new ThresholdTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ThresholdTreeLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ThresholdTreeComparator());
        this.createPopupMenu();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!ThresholdSummaryWidget.this.subscribed) {
                    return;
                }
                final NXCSession session = ConsoleSharedData.getSession();
                ConsoleJob job = new ConsoleJob("Unsubscribe from threshold notifications", null, "org.netxms.ui.eclipse.datacollection"){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        session.unsubscribe("Core.DC.Thresholds");
                    }

                    protected String getErrorMessage() {
                        return "Cannot change event subscription";
                    }
                };
                job.setUser(false);
                job.setSystem(true);
                job.start();
            }
        });
        ConsoleSharedData.getSession().addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 12) {
                    final ThresholdStateChange stateChange = (ThresholdStateChange)n.getObject();
                    ThresholdSummaryWidget.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ThresholdSummaryWidget.this.processNotification(stateChange);
                        }
                    });
                }
            }
        });
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ThresholdSummaryWidget.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void processNotification(ThresholdStateChange stateChange) {
        if (this.refreshScheduled || this.object == null || this.object.getObjectId() != stateChange.getObjectId() && !this.object.isParentOf(stateChange.getObjectId())) {
            return;
        }
        this.refreshScheduled = true;
        this.getDisplay().timerExec(500, new Runnable(){

            @Override
            public void run() {
                ThresholdSummaryWidget.this.refreshScheduled = false;
                ThresholdSummaryWidget.this.refresh();
            }
        });
    }

    public void refresh() {
        if (this.visibilityValidator != null && !this.visibilityValidator.isVisible()) {
            return;
        }
        if (this.object == null) {
            this.viewer.setInput(new ArrayList(0));
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final long rootId = this.object.getObjectId();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ThresholdSummaryWidget_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", (MessageBar)this){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List data = session.getThresholdSummary(rootId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ThresholdSummaryWidget.this.isDisposed() || (this).ThresholdSummaryWidget.this.object == null || rootId != (this).ThresholdSummaryWidget.this.object.getObjectId()) {
                            return;
                        }
                        (this).ThresholdSummaryWidget.this.viewer.setInput((Object)data);
                        (this).ThresholdSummaryWidget.this.viewer.expandAll();
                    }
                });
                if (!ThresholdSummaryWidget.this.subscribed) {
                    session.subscribe("Core.DC.Thresholds");
                    ThresholdSummaryWidget.this.subscribed = true;
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ThresholdSummaryWidget_JobError;
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setObject(AbstractObject object) {
        this.object = object;
        this.refresh();
    }
}

