/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.ThresholdViolationSummary;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.ThresholdLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ThresholdTreeLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();
    private ThresholdLabelProvider thresholdLabelProvider = new ThresholdLabelProvider();
    private NXCSession session = ConsoleSharedData.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ThresholdViolationSummary && columnIndex == 0) {
            AbstractObject node = this.session.findObjectById(((ThresholdViolationSummary)element).getNodeId());
            return node != null ? this.wbLabelProvider.getImage((Object)node) : null;
        }
        if (element instanceof ThresholdViolationSummary && columnIndex == 1) {
            return StatusDisplayInfo.getStatusImage((Severity)((ThresholdViolationSummary)element).getCurrentSeverity());
        }
        if (element instanceof DciValue && columnIndex == 1) {
            return StatusDisplayInfo.getStatusImage((Severity)((DciValue)element).getActiveThreshold().getCurrentSeverity());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ThresholdViolationSummary) {
            switch (columnIndex) {
                case 0: {
                    AbstractObject node = this.session.findObjectById(((ThresholdViolationSummary)element).getNodeId());
                    return node != null ? node.getNameWithAlias() : null;
                }
                case 1: {
                    return StatusDisplayInfo.getStatusText((Severity)((ThresholdViolationSummary)element).getCurrentSeverity());
                }
            }
            return null;
        }
        if (element instanceof DciValue) {
            switch (columnIndex) {
                case 1: {
                    return StatusDisplayInfo.getStatusText((Severity)((DciValue)element).getActiveThreshold().getCurrentSeverity());
                }
                case 2: {
                    return ((DciValue)element).getDescription();
                }
                case 3: {
                    return ((DciValue)element).getValue();
                }
                case 4: {
                    return this.thresholdLabelProvider.getColumnText(((DciValue)element).getActiveThreshold(), 0);
                }
                case 5: {
                    return RegionalSettings.getDateTimeFormat().format(((DciValue)element).getActiveThreshold().getLastEventTimestamp());
                }
            }
            return null;
        }
        return null;
    }

    public void dispose() {
        this.wbLabelProvider.dispose();
        this.thresholdLabelProvider.dispose();
        super.dispose();
    }
}

